unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, MathEdit, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    PaintBox1: TPaintBox;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    x0, y0    : Integer; { Ort des Ursprungs in PaintBox1 }
    xmin, xmax,          { Zeichenbereich in              }
    ymin, ymax,          {     User-Koordinaten           }
    ppcm      : Double;  { Pixel per Zentimeter           }
    function userx(pbx: Integer): Double;
    function usery(pby: Integer): Double;
    function paintx(ux: Double): Integer;
    function painty(uy: Double): Integer;
    function f(x: Double): Double;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ =========== Interne Hilfsfunktionen ============= }

function TForm1.userx(pbx: Integer): Double;
  begin
  userx := (pbx - x0) / ppcm;
  end;

function TForm1.usery(pby: Integer): Double;
  begin
  usery := (y0 - pby) / ppcm;
  end;

function TForm1.paintx(ux: Double): Integer;
  begin
  Result := Round(ux*ppcm + x0);
  end;

function TForm1.painty(uy: Double): Integer;
  begin
  Result := Round(y0 - uy*ppcm);
  end;

function TForm1.f(x: Double): Double;
  begin
  Result := 3*sin(x);
  end;

{ ========= Methoden ============== }

procedure TForm1.FormCreate(Sender: TObject);
  begin
  ppcm := 37.4;                    { Skalierung initialisieren }
  x0   := PaintBox1.Width Div 2;
  y0   := PaintBox1.Height Div 2;

  xmin := userx(0);                { Zeichenbereich ermitteln  }
  xmax := userx(PaintBox1.Width);
  ymin := usery(PaintBox1.Height);
  ymax := usery(0);
  end;

procedure TForm1.Button1Click(Sender: TObject);
  var x, y, dx : Double;
  begin
  With PaintBox1.Canvas do begin
    MoveTo(paintx(xmin), painty(0));  { Achsen zeichnen }
    LineTo(paintx(xmax), painty(0));
    MoveTo(paintx(0), painty(ymin));
    LineTo(paintx(0), painty(ymax));

    x := Round(xmin);     { x-Achse skalieren und beschriften }
    While x < xmax do begin
      MoveTo(paintx(x), painty(0.1));
      LineTo(paintx(x), painty(-0.1));
      If Abs(x) > 0.2 then
        TextOut(paintx(x) - 5, painty(-0.15), IntToStr(Round(x)));
      x := x + 1;
      end;

    y := Round(ymin);     { y-Achse skalieren und beschriften }
    While y < ymax do begin
      MoveTo(paintx(-0.1), painty(y));
      LineTo(paintx(0.1), painty(y));
      If Abs(y) > 0.2 then
        TextOut(paintx(0.15), Painty(y) - 6, IntToStr(Round(y)));
      y := y + 1;
      end;

    x := Round(xmin);      { Orientierungspnktli malen }
    While x < xmax do begin
      y := Round(ymin);
      While y < ymax do begin
        Pixels[paintx(x), painty(y)] := clBlack;
        y := y + 1;
        end;
      x := x + 1;
      end;

    x := xmin;         { Schaubild zeichnen }
    y := f(x);
    dx := 1/ppcm;
    MoveTo(paintx(x), painty(y));
    While x < xmax do begin
      x := x + dx;
      y := f(x);
      LineTo(paintx(x), painty(y));
      end;
    end;
  end;

end.
