unit ClientTestUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, ComCtrls, ScktComp, StdCtrls;

type
  TForm1 = class(TForm)
    StatusBar1: TStatusBar;
    Panel1: TPanel;
    SB_Exit: TSpeedButton;
    ClientSocketTX: TClientSocket;
    EditIP: TEdit;
    SB_Connect: TSpeedButton;
    MemoLog: TMemo;
    procedure SB_ExitClick(Sender: TObject);
    procedure SB_ConnectClick(Sender: TObject);
    procedure ClientSocketTXConnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure ClientSocketTXConnecting(Sender: TObject; Socket: TCustomWinSocket);
    procedure ClientSocketTXDisconnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure ClientSocketTXError(Sender: TObject; Socket: TCustomWinSocket; ErrorEvent: TErrorEvent; var ErrorCode: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{========== Verbindung aufbauen ======================}

procedure TForm1.SB_ConnectClick(Sender: TObject);
  begin
  With ClientSocketTX do
    If Active then begin
      Close;
      Address := '';
      SB_Connect.Hint := 'Verbinden';
      end
    else begin
      Address := EditIP.Text;
      Open;
      SB_Connect.Hint := 'Trennen';
      end;
  end;

{========== Client-Socket-Ereignisse ==================}

procedure TForm1.ClientSocketTXConnect
                   (Sender: TObject; Socket: TCustomWinSocket);
  begin
  MemoLog.Lines.Add('OnConnect');
  With StatusBar1 do begin
    Panels[0].Text := 'Connect';
    Panels[1].Text := Socket.RemoteAddress;
    Panels[2].Text := IntToStr(Socket.RemotePort);
    Panels[3].Text := Socket.LocalAddress;
    Panels[4].Text := IntToStr(Socket.LocalPort);
    end;
  end;

procedure TForm1.ClientSocketTXConnecting
                   (Sender: TObject; Socket: TCustomWinSocket);
  begin
  MemoLog.Lines.Add('OnConnecting');
  end;

procedure TForm1.ClientSocketTXDisconnect
                   (Sender: TObject; Socket: TCustomWinSocket);
  begin
  MemoLog.Lines.Add('OnDisconnect');
  With StatusBar1 do begin
    Panels[0].Text := 'Disconnect';
    Panels[1].Text := '';
    Panels[2].Text := '';
    end;
  end;

procedure TForm1.ClientSocketTXError
                   (Sender: TObject; Socket: TCustomWinSocket;
                    ErrorEvent: TErrorEvent; var ErrorCode: Integer);
  begin
  MemoLog.Lines.Add('OnError : Error code = ' + IntToStr(ErrorCode));
  SB_Connect.Down := False;
  end;

{============= Programm beenden ====================}

procedure TForm1.SB_ExitClick(Sender: TObject);
  begin
  with ClientSocketTX do
    if Active then Close;
  Close;
  end;

end.
