unit ServerTestUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, ComCtrls, ScktComp, StdCtrls;

type
  TForm1 = class(TForm)
    StatusBar1: TStatusBar;
    Panel1: TPanel;
    SpBtnClose: TSpeedButton;
    ServerSocketListening: TServerSocket;
    MemoLog: TMemo;
    BtnClear: TButton;
    procedure SpBtnCloseClick(Sender: TObject);
    procedure ServerSocketListeningClientConnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure ServerSocketListeningAccept(Sender: TObject; Socket: TCustomWinSocket);
    procedure ServerSocketListeningClientDisconnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure ServerSocketListeningClientError(Sender: TObject; Socket: TCustomWinSocket; ErrorEvent: TErrorEvent; var ErrorCode: Integer);
    procedure ServerSocketListeningClientRead(Sender: TObject; Socket: TCustomWinSocket);
    procedure ServerSocketListeningClientWrite(Sender: TObject; Socket: TCustomWinSocket);
    procedure ServerSocketListeningListen(Sender: TObject; Socket: TCustomWinSocket);
    procedure FormCreate(Sender: TObject);
    procedure BtnClearClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
  begin
  ServerSocketListening.Open;
  StatusBar1.Panels[0].Text := 'Listening';
  end;

{====== ServerSocket-Ereignisse =================== }

procedure TForm1.ServerSocketListeningListen
                   (Sender: TObject; Socket: TCustomWinSocket);
  begin
  MemoLog.Lines.Add('OnListen');
  end;

procedure TForm1.ServerSocketListeningClientConnect
                   (Sender: TObject; Socket: TCustomWinSocket);
  begin
  MemoLog.Lines.Add('OnClientConnect');
  With StatusBar1 do begin
    Panels[0].Text := 'Connect';
    Panels[1].Text := Socket.RemoteAddress;
    Panels[2].Text := IntToStr(Socket.RemotePort);
    Panels[3].Text := Socket.LocalAddress;
    Panels[4].Text := IntToStr(Socket.LocalPort);
    end;
  end;

procedure TForm1.ServerSocketListeningAccept
                   (Sender: TObject; Socket: TCustomWinSocket);
  begin
  MemoLog.Lines.Add('OnAccept');
  StatusBar1.Panels[0].Text := 'Accept';
  end;

procedure TForm1.ServerSocketListeningClientDisconnect
                   (Sender: TObject; Socket: TCustomWinSocket);
  begin
  MemoLog.Lines.Add('OnDisconnect');
  With StatusBar1 do begin
    Panels[0].Text := 'Disconnect';
    Panels[1].Text := '';
    Panels[2].Text := '';
    end;
  end;

procedure TForm1.ServerSocketListeningClientRead
                   (Sender: TObject; Socket: TCustomWinSocket);
  begin
  MemoLog.Lines.Add('OnClientRead');
  With StatusBar1 do begin
    Panels[1].Text := Socket.RemoteAddress;
    Panels[2].Text := IntToStr(Socket.RemotePort);
    end;
  end;

procedure TForm1.ServerSocketListeningClientWrite
                   (Sender: TObject; Socket: TCustomWinSocket);
  begin
  MemoLog.Lines.Add('OnClientWrite');
  end;

procedure TForm1.ServerSocketListeningClientError
                   (Sender: TObject; Socket: TCustomWinSocket;
                    ErrorEvent: TErrorEvent; var ErrorCode: Integer);
  begin
  MemoLog.Lines.Add('OnClientError -> ErrorCode = ' + IntToStr(ErrorCode));
  end;


{========== Log-Fenster lschen ======================}

procedure TForm1.BtnClearClick(Sender: TObject);
  begin
  MemoLog.Clear;
  end;


{=========== Programm beenden ========================}

procedure TForm1.SpBtnCloseClick(Sender: TObject);
  begin
  with ServerSocketListening do
    if Active then Close;
  Close;
  end;

end.
