unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TBruch = class(TObject)
             zaehler : Integer;
             nenner  : Integer;
             constructor Create(i_zaehler, i_nenner: Integer);
             destructor Destroy;
             function   ggT(a, b: Integer): Integer;
             function   AsString: String;
             procedure  Kuerze;
           end;

  TGemZahl = class(TBruch)
               gz : Integer;
               constructor Create(i_gz, i_z, i_n : Integer);
               function AsString: String;
             end;

  TForm1 = class(TForm)
    Edit1: TEdit;
    Button1: TButton;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private-Deklarationen }
    br1 : TGemZahl;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{=============== Methoden von TBruch =========================}

constructor TBruch.Create(i_zaehler, i_nenner: Integer);
  begin
  Inherited Create;
  zaehler := i_zaehler;
  nenner  := i_nenner;
  end;

destructor TBruch.Destroy;
  begin
  Inherited Destroy;
  end;

function TBruch.ggT(a, b: Integer): Integer;
  var r : Integer;
  begin
  If a < b then begin
    r := a; a := b; b := r;
    end;
  While b > 0 do begin
    r := a MOD b;
    a := b;
    b := r;
    end;
  Result := a;
  end;

function TBruch.AsString: String;
  begin
  Result := IntToStr(zaehler) + '/' + IntToStr(nenner);
  end;

procedure TBruch.Kuerze;
  var k : Integer;
  begin
  k := ggT(zaehler, nenner);
  zaehler := zaehler div k;
  nenner  := nenner  div k;
  end;

{============= Methoden von TGemZahl ==========================}

constructor TGemZahl.Create(i_gz, i_z, i_n : Integer);
  begin
  Inherited Create(i_z, i_n);
  gz := i_gz;
  end;

function TGemZahl.AsString: String;
  begin
  Result := IntToStr(gz) + ' ' + Inherited AsString;
  end;  

{============= Methoden des Formulars =========================}

procedure TForm1.FormCreate(Sender: TObject);
  begin
  br1 := TGemZahl.Create(2, 75, 100);
  end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
  begin
  br1.Destroy;
  end;

procedure TForm1.Button1Click(Sender: TObject);
  begin
  Edit1.Text := br1.AsString;
  end;

procedure TForm1.Button2Click(Sender: TObject);
  begin
  br1.Kuerze;
  end;

end.
