unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, mTVLInt;

type
  TForm1 = class(TForm)
    PrimList: TListBox;
    Panel1: TPanel;
    BtnStart: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    BtnStop: TButton;
    BtnSave: TButton;
    Label2: TLabel;
    Edit2: TEdit;
    Label3: TLabel;
    Edit3: TEdit;
    Label4: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure BtnStartClick(Sender: TObject);
    procedure BtnStopClick(Sender: TObject);
    procedure BtnSaveClick(Sender: TObject);
  private
    { Private-Deklarationen }
    PrimZahl : TList;
    run      : Boolean;
    LastPrimIndex : Integer;
    StartTime,
    StopTime : Integer;
    function IsPrim(c : TVLInt): Boolean;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
  var i : Integer;
  begin
  PrimZahl := TList.Create;
  If FileExists('primlist.txt') then begin
    PrimList.Items.LoadFromFile('primlist.txt');
    For i := 0 to Pred(PrimList.Items.Count) do
      PrimZahl.Add(TVLInt.Create(PrimList.Items[i]));
    Edit1.Text := IntToStr(PrimZahl.Count);
    end
  else begin
    PrimZahl.Add(TVLInt.Create('2'));
    PrimZahl.Add(TVLInt.Create('3'));
    PrimZahl.Add(TVLInt.Create('5'));
    For i := 0 to 2 do
      PrimList.Items.Add(TVLInt(PrimZahl.Items[i]).AsString);
    Edit1.Text := '3';  
    end;
  Edit2.Text := TVLInt(PrimZahl.Items[PrimZahl.Count-1]).AsString;  
  LastPrimIndex := 1;
  end;

function TForm1.IsPrim(c : TVLInt): Boolean;
  var tc    : TVLInt;
      ready : Boolean;
      i     : Integer;
  begin
  Result := True;
  ready  := False;
  tc := TVLInt.Create('0');
  i := 1;
  Repeat
    tc.Assign(c);
    tc.Modulo(TVLInt(PrimZahl[i]));
    If tc.IsNull then
      Result := False
    else begin
      If i > LastPrimIndex then begin
        tc.Assign(Primzahl[i]);
        tc.Mult(Primzahl[i]);
        ready := tc.IsGreaterThan(c);
        LastPrimIndex := i;
        end;
      i := i + 1;
      end;
  until (Not Result) or ready;
  end;

procedure TForm1.BtnStartClick(Sender: TObject);
  var candi, step : TVLInt;
      i : Integer;
  begin
  PrimList.Clear;
  run   := True;
  StartTime := GetTickCount;
  step  := TVLInt.Create('2');
  While run do begin
    candi := TVLInt.CreateCopyOf(TVLInt(PrimZahl.Items[PrimZahl.Count-1]));
    candi.Add(step);
    While not IsPrim(candi) do
      candi.Add(step);
    PrimZahl.Add(candi);
    Edit1.Text := IntToStr(Primzahl.Count);
    Edit2.Text := candi.AsString;
    Application.ProcessMessages;
    If PrimZahl.Count = 1000 then begin
      StopTime := GetTickCount;
      Edit3.Text := IntToStr(StopTime - StartTime);
      end;
    end;
  For i := 0 to Pred(PrimZahl.Count) do
    PrimList.Items.Add(TVLInt(PrimZahl[i]).AsString);
  end;

procedure TForm1.BtnStopClick(Sender: TObject);
  begin
  run := False;
  end;

procedure TForm1.BtnSaveClick(Sender: TObject);
  begin
  If run then
    MessageBeep(MB_ICONASTERISK)
  else
    PrimList.Items.SaveToFile('primlist.txt');
  end;

end.
