unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls,
  mTVLInt, mRSATools, ExtCtrls;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label6: TLabel;
    Edit1: TEdit;
    BtnKeyCreate: TButton;
    Edit2: TEdit;
    Edit3: TEdit;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Label7: TLabel;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    GroupBox3: TGroupBox;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Edit7: TEdit;
    BtnEncrypt: TButton;
    Edit8: TEdit;
    BtnDecrypt: TButton;
    Edit9: TEdit;
    Bevel1: TBevel;
    Bevel2: TBevel;
    procedure BtnKeyCreateClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BtnEncryptClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BtnDecryptClick(Sender: TObject);
  private
    { Private-Deklarationen }
    n, e, d : TVLInt;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
  begin
  Randomize;
  n := TVLInt.Create('0');
  e := TVLInt.Create('0');
  d := TVLInt.Create('0');
  BtnEncrypt.Enabled := False;
  BtnDecrypt.Enabled := False;
  end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
  begin
  n.Free;
  e.Free;
  d.Free;
  end;

procedure TForm1.BtnKeyCreateClick(Sender: TObject);
  var n1, n2, 
      e_start   : Integer;
      iw        : Double;
      p, q, phi,
      kphi1, kphi2,
      eins      : TVLInt;
  begin
  BtnKeyCreate.Cursor := crHourGlass;

  n1 := StrToInt(Edit1.Text);
  n2 := StrToInt(Edit2.Text);
  iw := StrToFloat(Edit3.Text);
  Edit4.Text := '';
  Edit5.Text := '';
  Edit6.Text := '';
  Edit8.Text := '';
  Edit9.Text := '';
  Application.ProcessMessages;

  p := TVLInt.Create('0');
  q := TVLInt.Create('0');
  SetVLRandomNumber(n1, p);
  SetVLRandomNumber(n2, q);
  MillerRabinPrim(iw, p);
  MillerRabinPrim(iw, q);
  n.Assign(p);
  n.Mult(q);
  Edit4.Text := n.AsString;
  Application.ProcessMessages;

  eins := TVLInt.Create('1');
  q.Subtr(eins);
  phi := TVLInt.CreateCopyOf(p);
  phi.Subtr(eins);
  phi.Mult(q);
  q.Add(eins);
  e_start := 20 + Random(80);
  e := TVLInt.Create(IntToStr(e_start));
  Repeat
    e.Add(eins);
  until CoPrime(e, phi);
  Edit5.Text := e.AsString;
  Application.ProcessMessages;

  kphi1 := TVLInt.Create('1');
  kphi2 := TVLInt.Create('0');
  Repeat
    kphi1.Add(phi);
    kphi2.Assign(kphi1);
    kphi2.Modulo(e);
  until kphi2.IsNull;
  d := TVLInt.CreateCopyOf(kphi1);
  d.DivBy(e);
  Edit6.Text := d.AsString;
  Application.ProcessMessages;

  kphi2.Free;
  kphi1.Free;
  phi.Free;
  p.Free;
  q.Free;
  eins.Free;

  BtnEncrypt.Enabled  := True;
  BtnDecrypt.Enabled  := True;
  BtnKeyCreate.Cursor := crDefault;
  end;

procedure TForm1.BtnEncryptClick(Sender: TObject);
  var m, c : TVLInt;
  begin
  m := TVLInt.Create(Edit7.Text);
  c := TVLInt.Create('0');
  ExpMod(m, e, n, c);
  Edit8.Text := c.AsString;
  Edit9.Text := '';
  c.Free;
  m.Free;
  end;

procedure TForm1.BtnDecryptClick(Sender: TObject);
  var c, u : TVLInt;
  begin
  c := TVLInt.Create(Edit8.Text);
  u := TVLInt.Create('0');
  ExpMod(c, d, n, u);
  Edit9.Text := u.AsString;
  u.Free;
  c.Free;
  end;

end.
