unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, ExtCtrls,
  xxcode, mTVLInt, mRSATools, Buttons, Menus;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Memo1: TMemo;
    Memo2: TMemo;
    Label2: TLabel;
    BitBtn_Encode: TBitBtn;
    BitBtn_Decode: TBitBtn;
    Bevel1: TBevel;
    ComboBox_Friends: TComboBox;
    Label3: TLabel;
    Btn_ConfigureFriends: TButton;
    BitBtn_Back: TBitBtn;
    MainMenu1: TMainMenu;
    Datei1: TMenuItem;
    Beenden1: TMenuItem;
    Freunde1: TMenuItem;
    Freundebearbeiten1: TMenuItem;
    PrivatenSchlsselbearbeiten1: TMenuItem;
    N1: TMenuItem;
    Info1: TMenuItem;
    Nachrichtentschlsseln1: TMenuItem;
    NAchrichtvershclsseln1: TMenuItem;
    N2: TMenuItem;
    zurckzumStartbildschirm1: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    BitBtn_LoadFromFile: TBitBtn;
    BitBtn_SaveToFile: TBitBtn;
    procedure FormShow(Sender: TObject);
    procedure Btn_SaveToFileClick(Sender: TObject);
    procedure Btn_LoadFromFileClick(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure PrivatenSchlsselbearbeiten1Click(Sender: TObject);
    procedure Freundebearbeiten1Click(Sender: TObject);
    procedure Beenden1Click(Sender: TObject);
    procedure Nachrichtentschlsseln1Click(Sender: TObject);
    procedure NAchrichtvershclsseln1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BitBtn_BackClick(Sender: TObject);
    procedure Btn_ConfigureFriendsClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BiBtn_EncodeClick(Sender: TObject);
    procedure BiBtn_DecodeClick(Sender: TObject);
    procedure PrepareEncode;
    procedure PrepareDecode;
  private
    { Private-Deklarationen }
    index: integer;
  public
    { Public-Deklarationen }
    maxL       : Integer;
    XXCodec    : TXXCodec;
    pname      : String;          // eigener Name 
    pn, pe, pd : TVLInt;          // privater Schlssel
    procedure RefreshFriendsList;
  end;

var
  Form1: TForm1;


implementation

uses
  mCrypt, UnitFriends, UnitStart, UnitPrivateKey, UnitAbout;

{$R *.dfm}


// ---------------------- Form1 ------------------------

procedure TForm1.FormCreate(Sender: TObject);
  begin
  XXCodec := TXXCodec.Create('');
  maxL := 60;

  pn := TVLInt.Create('0');
  pe := TVLInt.Create('0');
  pd := TVLInt.Create('0');

  Form1.Height := 549;  // stimmt sonst nicht immer ( wegen Menu)
  end;

procedure TForm1.FormShow(Sender: TObject);
begin
  PrepareEncode;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  XXCodec.Free;
  pn.Free;
  pe.Free;
  pd.Free;
end;

// ---------------------- Hilfsfunktionen ------------------------

procedure TForm1.RefreshFriendsList;
var i: integer;
begin
  index := ComboBox_Friends.ItemIndex;
  ComboBox_Friends.Clear;
  for i := 0 to length(FormFriends.Friends) - 1 do
    ComboBox_Friends.Items.Add(FormFriends.Friends[i].Name);
  ComboBox_Friends.ItemIndex := index;
end;

procedure TForm1.PrepareEncode;
begin
  if length(FormFriends.Friends) = 0 then
    begin
    MessageDlg('Sie mssen zuerst  einen Freund mit einem Schlssel zum '
             + 'Entschlsseln einer Nachricht hinzufgen.', mtError, [mbOK], 0);
    FormFriends.ShowModal;
    PrepareDecode;
    exit;
    end;
  Memo1.Font.Name := 'MS Sans Serif';
  Memo2.Font.Name := 'Courier';
  Memo1.Clear;
  Memo2.Clear;
  Label2.Caption := 'verschlsselte Nachricht:';
  BitBtn_Encode.Enabled := true;
  ComboBox_Friends.Enabled := true;
  Btn_ConfigureFriends.Enabled := true;
  BitBtn_Decode.Enabled := false;
  ComboBox_Friends.ItemIndex := 0;
end;

procedure TForm1.PrepareDecode;
begin
  Memo1.Font.Name := 'Courier';
  Memo2.Font.Name := 'MS Sans Serif';
  Memo1.Clear;
  Memo2.Clear;
  Label2.Caption := 'entschlsselte Nachricht:';
  BitBtn_Encode.Enabled := false;
  ComboBox_Friends.Enabled := false;
  Btn_ConfigureFriends.Enabled := false;
  BitBtn_Decode.Enabled := true;
end;


// ---------------------- Buttons ------------------------

procedure TForm1.BiBtn_EncodeClick(Sender: TObject);
  var n, e: TVLInt;
  begin
  Form1.Enabled := false;
  Memo2.Text := 'Verschlsselung luft, bitte warten ...';
  Application.ProcessMessages;

  n := TVLInt.Create(FormFriends.Friends[ComboBox_Friends.ItemIndex].n);
  e := TVLInt.Create(FormFriends.Friends[ComboBox_Friends.ItemIndex].e);
  EnCrypt(n, e, Memo1.Lines, Memo2.Lines);

  n.Free;
  e.Free;
  Form1.Enabled := true;
  end;

procedure TForm1.BiBtn_DecodeClick(Sender: TObject);
  begin
  Form1.Enabled := false;
  Memo2.Text := 'Entschlsselung luft, bitte warten ...';
  Application.ProcessMessages;
  try
    DeCrypt(pn, pd, Memo1.Lines, Memo2.Lines);
  except
    Memo2.Clear;
    Memo2.Lines.Add('Bei der Entschlsselung trat ein Fehler auf.');
    Memo2.Lines.Add('Bitte vergewissern Sie sich, dass der verschlsselte Text komplett ist und fr Sie bestimmt ist.');
  end;
  Form1.Enabled := true;
  end;

procedure TForm1.Btn_ConfigureFriendsClick(Sender: TObject);
begin
  FormFriends.ShowModal;
end;
procedure TForm1.BitBtn_BackClick(Sender: TObject);
begin
  FormStart.Visible := true;
  Form1.Visible := false;
end;

procedure TForm1.Btn_LoadFromFileClick(Sender: TObject);
begin
  if OpenDialog1.Execute and FileExists(OpenDialog1.FileName)
    then Memo1.Lines.LoadFromFile(OpenDialog1.FileName);
end;

procedure TForm1.Btn_SaveToFileClick(Sender: TObject);
begin
  if SaveDialog1.Execute then Memo2.Lines.SaveToFile(SaveDialog1.FileName);
end;


// ------------------- Menu ----------------------------

procedure TForm1.NAchrichtvershclsseln1Click(Sender: TObject);
begin
  PrepareEncode;
end;

procedure TForm1.Nachrichtentschlsseln1Click(Sender: TObject);
begin
  PrepareDecode;
end;

procedure TForm1.Beenden1Click(Sender: TObject);
begin
  close;
end;

procedure TForm1.Freundebearbeiten1Click(Sender: TObject);
begin
  FormFriends.ShowModal;
end;

procedure TForm1.PrivatenSchlsselbearbeiten1Click(Sender: TObject);
begin
  FormPrivateKey.ShowModal;
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
  FormAbout.ShowModal;
end;

end.
