unit UnitFriends;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls, ExtCtrls, mTVLInt, Buttons, StrUtils;

type
  TFriends = record
    Name, n, e: string;
    end;

  TFormFriends = class(TForm)
    ListBox_Friends: TListBox;
    Label1: TLabel;
    Ed_Friend: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    GroupBox1: TGroupBox;
    Bevel1: TBevel;
    Ed_n: TEdit;
    Ed_e: TEdit;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    BitBtn_Add: TBitBtn;
    BitBtn_Import: TBitBtn;
    BitBtn_Export: TBitBtn;
    BitBtn_Save: TBitBtn;
    BitBtn_Delete: TBitBtn;
    BitBtn_Back: TBitBtn;
    procedure Btn_ExportClick(Sender: TObject);
    procedure Btn_ImportClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure Btn_DeleteClick(Sender: TObject);
    procedure ListBox_FriendsClick(Sender: TObject);
    procedure Btn_SaveClick(Sender: TObject);
    procedure Btn_AddClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Btn_BackClick(Sender: TObject);
  private
    { Private declarations }
    index: integer;
    publikey_path: String;
    procedure LoadPublicKeys;
    procedure ShowFriends;
  public
    { Public declarations }
    Friends: array of TFriends;
    procedure SaveFriends;
  end;

var
  FormFriends: TFormFriends;

implementation

uses Unit1, UnitPrivateKey;

{$R *.dfm}

// ---------------------- FormFriends ------------------------

procedure TFormFriends.FormCreate(Sender: TObject);
begin
  publikey_path := ExtractFilePath(Application.ExeName) + 'public.key';
  LoadPublicKeys;
  Form1.RefreshFriendsList;
end;

procedure TFormFriends.FormShow(Sender: TObject);
begin
  index := 0;
  ShowFriends;
  ListBox_Friends.ItemIndex := 0;
  ListBox_Friends.OnClick(Sender);
end;

procedure TFormFriends.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Form1.RefreshFriendsList;
end;


// ---------------------- Hilfsfunktionen ------------------------

procedure TFormFriends.LoadPublicKeys;
var
  sl: TStrings;
  s: string;
  i: integer;
begin
  if not FileExists(publikey_path) then begin
    SetLength(Friends, 0);
    exit;
    end;

  // Stringlist erstellen
  sl := TStringList.Create;
  sl.LoadFromFile(publikey_path);
  sl.Delete(0);   // Spaltenberschriften lschen
  SetLength(Friends, sl.Count);

  // Schlssel extrahieren
  for i := 0 to sl.Count - 1 do
    begin
    s := sl[i];
    Delete(s, 1, pos(';', s)); // Index rauslschen
    Friends[i].Name := Copy(s, 1, pos(';', s) - 1);
    Delete(s, 1, pos(';', s));
    Friends[i].n := Copy(s, 1, pos(';', s) - 1);
    Delete(s, 1, pos(';', s));
    Friends[i].e := s;
    end;
  sl.Free;
end;

procedure TFormFriends.ShowFriends;
var i: integer;
begin
  ListBox_Friends.Clear;
  for i := 0 to length(Friends) - 1 do
    ListBox_Friends.Items.Add(Friends[i].Name);
  if index = -1 then
    ListBox_Friends.ItemIndex := ListBox_Friends.Items.Count - 1
  else
    begin
      if index > ListBox_Friends.ItemIndex then
        index := ListBox_Friends.Items.Count - 1;
      ListBox_Friends.ItemIndex := index;
    end;
  ListBox_Friends.OnClick(ListBox_Friends);
end;

procedure TFormFriends.SaveFriends;
var
  i: integer;
  sl: TStrings;
begin
  sl := TStringList.Create;
  sl.Add('Id;Name;n;e');
  for i := 0 to length(Friends) - 1
    do sl.Add(IntToStr(i) + ';' + Friends[i].Name + ';' + Friends[i].n + ';'
       + Friends[i].e);
  sl.SaveToFile(publikey_path);
  sl.Free;
end;

// ---------------------- Buttons ------------------------

procedure TFormFriends.Btn_BackClick(Sender: TObject);
begin
  close;
end;

procedure TFormFriends.Btn_AddClick(Sender: TObject);
begin
  Ed_Friend.Text := 'Freund ' + IntToStr(length(Friends) + 1);
  Ed_n.Text := '0';
  Ed_e.Text := '0';

  SetLength(Friends, length(Friends) + 1);
  index := length(Friends) - 1;
  Btn_SaveClick(sender);
  GroupBox1.Enabled := true;
end;

procedure TFormFriends.Btn_SaveClick(Sender: TObject);
begin
  // berprfung des Schlssels
  if (Ed_n.Text = '') or (Ed_e.Text = '') then
    begin
      MessageDlg('Der eingegebene Schlssel ist fehlerhaft.' + #13
               + 'Bitte berprfen Sie ihn noch einmal.', mtError, [mbOK], 0);
      exit;
    end;

  // berprfung des Namens
  if pos(';', Ed_Friend.Text) > 0 then
    begin
      MessageDlg('In dem Namen darf kein Semikolon (";") vorkommen!', mtError, [mbOK], 0);
      exit;
    end;

  // Speichern des Schlssels
  with Friends[index] do
    begin
    Name := Ed_Friend.Text;
    n := Ed_n.Text;
    e := Ed_e.Text;
    end;
  SaveFriends;
  ShowFriends;
end;

procedure TFormFriends.Btn_DeleteClick(Sender: TObject);
var i: integer;
begin
  if (index >= 0) and (index <= High(Friends)) and 
     (MessageDlg('Wollen Sie ' + Friends[index].Name + ' wirklich lschen?',
                 mtError, [mbYes, mbNo], 0) = mrYes) then
    begin
    for i := index to length(Friends) - 2 do Friends[i] := Friends[i+1];
    SetLength(Friends, length(Friends) - 1);
    SaveFriends;
    ShowFriends;
    end;
end;

procedure TFormFriends.ListBox_FriendsClick(Sender: TObject);
begin
  Ed_Friend.Text := '';
  Ed_n.Text := '';
  Ed_e.Text := '';
  if ListBox_Friends.Items.Count = 0 then
    begin // keine Freunde vorhanden
    Ed_Friend.Text := '(Bitte fgen Sie zuerst einen neuen Freund hinzu!)';
    GroupBox1.Enabled := false;
    end
  else begin
    index := ListBox_Friends.ItemIndex;
    If index >= 0 then begin
      Ed_Friend.Text := Friends[index].Name;
      Ed_n.Text := Friends[index].n;
      Ed_e.Text := Friends[index].e;
      end;
    end;
end;


// ---------------------- Import / Export ------------------------

procedure TFormFriends.Btn_ImportClick(Sender: TObject);
var
  sl: TStrings;
  s, name1, n, e: string;
  i, j: integer;
  doppelt, NameDoppelt: boolean;
begin
  sl := TStringList.Create;
  if OpenDialog1.Execute and FileExists(OpenDialog1.FileName) then
    begin
    sl.LoadFromFile(OpenDialog1.FileName);
    if sl[0] <> 'Id;Name;n;e'  // Datei ungltig
      then MessageDlg('Die ausgewhlte Datei (' + OpenDialog1.FileName + ') ist ungltig.',
                 mtError, [mbOK], 0)
    else   // Datei gltig
      for i := 1 to sl.Count - 1 do           
        begin
        // Datenzeile einlesen und Name, n, e extrahieren
        s := sl[i];
        Delete(s, 1, pos(';', s)); // Index
        name1 := Copy(s, 1, pos(';', s) - 1);
        Delete(s, 1, pos(';', s));
        n := Copy(s, 1, pos(';', s) - 1);
        Delete(s, 1, pos(';', s));
        e := s;

        // berprfung, ob Name, n, e schon vorhanden
        doppelt := false;
        NameDoppelt := false;
        for j := 0 to length(Friends) - 1 do
          begin
          if (Friends[j].n = n) and (Friends[j].e = e) then doppelt := true;
          if Friends[j].Name = name1 then NameDoppelt := true;
          end;
        if doppelt then
          begin
          MessageDlg('Der Freund "' + name1 + '" ist schon vorhanden und wird nicht neu hinzugefgt.',
                     mtError, [mbOK], 0);
          break;
          end;
        if NameDoppelt then
          begin
          repeat
            InPutQuery('RSAlex', 'Der Name "' + name1 + '" ist bereits fr einen anderen Freund vergeben.' + #13 + 'Neuen Freund umbenennen in:', name1);
            NameDoppelt := false;
            for j := 0 to length(Friends) - 1 do
              if Friends[j].Name = name1 then NameDoppelt := true;
          until
            NameDoppelt = false;
          end;

        // Freund eintragen
        SetLength(Friends, length(Friends) + 1);
        Friends[length(Friends) - 1].Name := name1;
        Friends[length(Friends) - 1].n := n;
        Friends[length(Friends) - 1].e := e;
        end;
    SaveFriends;
    ShowFriends;
    end;
  sl.Free;
end;

procedure TFormFriends.Btn_ExportClick(Sender: TObject);
var
  sl: TStrings;
  i: integer;
begin
  sl := TStringList.Create;
  sl.Add('Id;Name;n;e');
  for i := 0 to length(Friends) - 1
    do sl.Add(IntToStr(i) + ';' + Friends[i].Name + ';' + Friends[i].n + ';'
       + Friends[i].e);
  if SaveDialog1.Execute then sl.SaveToFile(SaveDialog1.FileName);
  sl.Free;
end;

end.
