unit UnitPrivateKey;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Buttons, mTVLInt;

type
  TFormPrivateKey = class(TForm)
    Ed_e: TEdit;
    Ed_n: TEdit;
    Label6: TLabel;
    Label5: TLabel;
    Label4: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    BitBtn_Back: TBitBtn;
    BitBtn_NewKey: TBitBtn;
    Bevel1: TBevel;
    SaveDialog1: TSaveDialog;
    Label3: TLabel;
    Bevel2: TBevel;
    BitBtn_Export: TBitBtn;
    Ed_Name: TEdit;
    Label7: TLabel;
    BitBtn_Save: TBitBtn;
    Bevel3: TBevel;
    procedure FormCreate(Sender: TObject);
    procedure Btn_ExportClick(Sender: TObject);
    procedure BitBtn_NewKeyClick(Sender: TObject);
    procedure BitBtn_BackClick(Sender: TObject);
  private
    { Private declarations }
    privatekey_path : String;
    function GetUsername: String;
  public
    { Public declarations }
    procedure CreateNewPrivateKey;
    procedure LoadPrivateKeys;
  end;

var
  FormPrivateKey: TFormPrivateKey;

const
  n_str = '811868017044547855930206335286847482071623415221390766576678253985172660938678171';
  e_str = '35';
  d_str = '139177374350493918159463943192030996926485879552494963476498518158805501987806939';


implementation

uses
  mRSATools, mCrypt, Unit1, UnitCreateKey, UnitFriends, UnitOwnName;

{$R *.dfm}


// ---------------------- FormPrivateKey ------------------------

procedure TFormPrivateKey.FormCreate(Sender: TObject);
begin
  privatekey_path := ExtractFilePath(Application.ExeName) + 'private.key';
  LoadPrivateKeys;
end;


// ---------------------- Hilfsfunktionen ------------------------

procedure TFormPrivateKey.CreateNewPrivateKey;
var
  n, e, d: TVLInt;
  sl: TStrings;
begin
  FormCreateKey.Show;
  FormPrivateKey.Enabled := false;
  Application.ProcessMessages;

  // berprfung des Namens
  if Form1.pname = '' then
    Form1.pname := GetUsername;
  Ed_Name.Text := Form1.pname;

  // Schlsselerzeugung
  n := TVLInt.Create('0');
  e := TVLInt.Create('0');
  d := TVLInt.Create('0');
  CreateRSAKeys(n, e, d);

  // Anzeige
  Ed_n.Text := n.AsString;
  Ed_e.Text := e.AsString;

  // Zwischenepeichern
  sl := TStringList.Create;
  sl.Add(Form1.pname);
  sl.Add(n.AsString);
  sl.Add(e.AsString);
  sl.Add(d.AsString);

  // Verschlsseln
  n.ResetTo(n_str);
  e.ResetTo(e_str);
  EnCrypt(n, e, sl, sl);

  // Speichern
  sl.SaveToFile(privatekey_path);
  sl.Free;
  n.Free;
  e.Free;
  d.Free;

  FormPrivateKey.Enabled := true;
  FormCreateKey.Close;
end;

procedure TFormPrivateKey.LoadPrivateKeys;
var
  sl: TStrings;
begin
  if not FileExists(privatekey_path) then begin
    CreateNewPrivateKey;
    end;

  // Auslesen
  sl := TStringList.Create;
  sl.LoadFromFile(privatekey_path);

  // Entschlsseln
  Form1.pn.ResetTo(n_str);
  Form1.pd.ResetTo(d_str);
  DeCrypt(Form1.pn, Form1.pd, sl, sl);

  // in Variablen speichern
  Form1.pname := sl.Strings[0];
  Form1.pn.Resetto(sl.Strings[1]);
  Form1.pe.Resetto(sl.Strings[2]);
  Form1.pd.Resetto(sl.Strings[3]);

  // Anzeige
  Ed_Name.Text := Form1.pname;
  Ed_n.Text := Form1.pn.AsString;
  Ed_e.Text := Form1.pe.AsString;
  sl.Free;
end;

function TFormPrivateKey.GetUsername: String;
begin
  If NameDlg.ShowModal = mrOk then
    Result := NameDlg.Edit1.Text
  else
    Result := '';   // Das sollte nie(!) passieren.
end;

// ---------------------- Buttons ------------------------

procedure TFormPrivateKey.BitBtn_NewKeyClick(Sender: TObject);
begin
  if MessageDlg('Wollen Sie wirklich einen neuen Schlssel erstellen?' + #13 + #13
              + 'Dadurch wird ihr alter Schlssel ungltig und Sie knnen' + #13
              + 'Nachrichten, die mit dem alten Schlssel verschlsselt' + #13
              + 'wurden, nicht mehr entschlsseln!'
                , mtConfirmation, [mbYes, mbNo], 0) = mrYes then
  begin
    CreateNewPrivateKey;
    LoadPrivateKeys;
  end;
end;

procedure TFormPrivateKey.BitBtn_BackClick(Sender: TObject);
begin
  close;
end;

procedure TFormPrivateKey.Btn_ExportClick(Sender: TObject);
var sl: TStrings;
begin
  sl := TStringList.Create;
  sl.Add('Id;Name;n;e');
  sl.Add('0;' + Ed_Name.Text + ';' + Form1.pn.AsString + ';' + Form1.pe.AsString);
  if SaveDialog1.Execute then sl.SaveToFile(SaveDialog1.FileName);
  sl.Free;
end;

end.
