unit UnitStart;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, IniFiles;

type
  TFormStart = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    BitBtn_Encode: TBitBtn;
    BitBtn_Decode: TBitBtn;
    BitBtn_Friends: TBitBtn;
    BitBtn_Key: TBitBtn;
    BitBtn_Exit: TBitBtn;
    CheckBox_ShowStart: TCheckBox;
    BitBtn_About: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BitBtn_AboutClick(Sender: TObject);
    procedure BitBtn_DecodeClick(Sender: TObject);
    procedure BitBtn_EncodeClick(Sender: TObject);
    procedure BitBtn_KeyClick(Sender: TObject);
    procedure BitBtn_FriendsClick(Sender: TObject);
    procedure BitBtn_ExitClick(Sender: TObject);
  private
    { Private declarations }
    ini: TIniFile;
  public
    { Public declarations }
  end;

var
  FormStart: TFormStart;

implementation

uses UnitFriends, UnitPrivateKey, Unit1, UnitAbout;

{$R *.dfm}


// ---------------------- FormStart ------------------------

procedure TFormStart.FormCreate(Sender: TObject);
begin
  ini := TIniFile.Create(ExtractFilePath(ParamStr(0)) + 'RSAlex.ini');
  CheckBox_ShowStart.Checked := ini.ReadBool('RSAlex', 'ShowStart', true);

  FormStart.Visible := CheckBox_ShowStart.Checked;
  Form1.Visible := not CheckBox_ShowStart.Checked;
end;

procedure TFormStart.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if ini.ReadBool('RSAlex', 'ShowStart', true) <> CheckBox_ShowStart.Checked
    then ini.WriteBool('RSAlex', 'ShowStart', CheckBox_ShowStart.Checked);
   {Dadurch wird die ini nur gespeichert, wenn sich der Wert verndert hat und
    bei den Standarteinstellungen gar nicht erst erstellt}
  ini.Free;

  Form1.Close;
end;


// ---------------------- Buttons ------------------------

procedure TFormStart.BitBtn_EncodeClick(Sender: TObject);
begin
  Form1.Show;
  Form1.PrepareEncode;
  FormStart.Visible := false;
end;

procedure TFormStart.BitBtn_DecodeClick(Sender: TObject);
begin
  Form1.Show;
  Form1.PrepareDecode;
  FormStart.Visible := false;
end;

procedure TFormStart.BitBtn_FriendsClick(Sender: TObject);
begin
  FormFriends.ShowModal;
end;

procedure TFormStart.BitBtn_KeyClick(Sender: TObject);
begin
  FormPrivateKey.ShowModal;
end;

procedure TFormStart.BitBtn_ExitClick(Sender: TObject);
begin
  close;
end;

procedure TFormStart.BitBtn_AboutClick(Sender: TObject);
begin
  FormAbout.ShowModal;
end;

end.
