unit mCrypt;


interface

uses
  Classes, SysUtils, mTVLInt;

  { Die folgenden beiden Prozeduren ver- bzw. entschlsseln die
    in der String-Liste InSL bergebene Botschaft und geben das
    Ergebnis in der String-Liste OutSL zurck. Fr InSL und OutSL
    kann auch dieselbe String-Liste bergeben werden, wobei dann
    das Ergebnis die ursprngliche Botschaft berschreibt. }

  procedure EnCrypt(n, e: TVLInt; InSL, OutSL: TStrings);
  { Zur Verschlsselung wird ein zufllig erzeugter XOR-Schlssel
    benutzt, der mit (n, e) RSA-kodiert der verschlsselten Botschaft
    als VLInt-Zahl vorangestellt wird. Die gesamte Botschaft wird
    schlielich mit einer Base64-Kodierung in einen email-
    tauglichen Text verwandelt. }

  procedure DeCrypt(n, d: TVLInt; InSL, OutSL: TStrings);
  { Zur Entschlsselung werden zunchst alle Zeilen der Geheim-
    botschaft zu einem langen String zusammengefgt und die Base64-
    Kodierung rckgngig gemacht. Dann wird der RSA-kodierte
    symmetrische Schlssel aus den Daten gelesen und mit Hilfe der
    bergebenen RSA-Schlssel (n, d) dekodiert. Mit Hilfe des so
    erhaltenen XOR-Schlssels wird schlielich der Geheimtext
    dekodiert. }


implementation

uses
  mRSATools, Unit1;


procedure EnCrypt(n, e: TVLInt; InSL, OutSL: TStrings);
var
  VLInt_SS,
  z       : TVLInt;
  MS      : TStream;
  m, s    : string;
  eb      : Byte;
  i, k    : integer;
begin
  // Nachricht-String zusammenstellen
  m := InSL.Text;

  // RSA-Verschlsselung des XOR-Schlssels
  VLInt_SS := GetRandomMask(GetMaxStrLength(n));
  z := TVLInt.Create('0');
  ExpMod(VLInt_SS, e, n, z);

  // verschlsselten XOR-Schlssel in Stream speichern
  MS := TMemoryStream.Create;
  MS.Position := 0;
  MS.Size     := 0;
  z.WriteToStream(MS);
  z.Free;

  // Schlssel-Bytes auspacken
  GetNumStringFromVLInt(VLInt_SS, s);  
  VLInt_SS.Free;

  // Nachricht als XOR-kodierte Bytefolge in Stream schreiben
  k := 1;
  For i := 1 to Length(m) do begin
    eb := Ord(m[i]) XOR Ord(s[k]);         // Zeichenweise verschlsseln und
    MS.WriteBuffer(eb, 1);                 //    in den Stream schreiben
    k := k + 1;
    If k > Length(s) then
      k := 1;
    end;

  // Stream in String codieren
  Form1.XXCodec.EncryptStream2XXString(MS, m);

  // codierter Text in TStrings (Lnge maxL) aufteilen
  OutSL.Clear;
  While Length(m) > 0 do
    begin
    If Length(m) > Form1.maxL then
      begin
      s := Copy(m, 1, Form1.maxL);
      Delete(m, 1, Form1.maxL);
      end
    else
      begin
      s := m;
      m := '';
      end;
    OutSL.Add(s)
    end;

end;

procedure DeCrypt(n, d: TVLInt; InSL, OutSL: TStrings);
var z,
    VLInt_SS: TVLInt;
    MS      : TStream;
    s, m    : string;
    eb      : Byte;
    i, k    : Integer;
begin
  // Strings zusammenfassen
  s := '';
  For i := 0 to Pred(InSL.Count) do
    s := s + InSL[i];

  // Strings in Stream decodieren
  MS := TMemoryStream.Create;
  Form1.XXCodec.DecryptXXString2Stream(s, MS);

  // Schlssel aus dem Stream lesen und dekodieren
  MS.Position := 0;
  VLInt_SS := TVLInt.Create('0');
  z := TVLInt.Create('0');
  z.ReadFromStream(MS);
  ExpMod(z, d, n, VLInt_SS);
  GetNumStringFromVLInt(VLInt_SS, s);

  // Text aus dem Stream lesen und dekodieren
  m  := '';    // Message !
  k  := 1;
  While MS.Position < MS.Size do begin
    MS.ReadBuffer(eb, 1);
    m := m + Chr(eb XOR Ord(s[k]));    // Text zeichenweise dekodieren
    k := k + 1;
    If k > Length(s) then
      k := 1;
    end;

  // String in Stringlist speichern
  OutSL.Clear;
  OutSL.Text := m;

  MS.Free;
  VLInt_SS.Free;
end;

end.
