unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, ExtCtrls,
  mTVLInt, mRSATools;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Memo1: TMemo;
    BtnEncode: TButton;
    Label2: TLabel;
    Memo2: TMemo;
    BtnDecode: TButton;
    Label3: TLabel;
    Memo3: TMemo;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure BtnEncryptClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BtnDecryptClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
    n, e, d,
    mask    : TVLInt;
    maxL    : Integer;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

const
  n_str = '811868017044547855930206335286847482071623415221390766576678253985172660938678171';
  e_str = '35';
  d_str = '139177374350493918159463943192030996926485879552494963476498518158805501987806939';


procedure TForm1.FormCreate(Sender: TObject);
  begin
  n := TVLInt.Create(n_str);
  e := TVLInt.Create(e_str);
  d := TVLInt.Create(d_str);
  maxL := GetMaxStrLength(n_str);
  Button1Click(Self);
  end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
  begin
  n.Free;
  e.Free;
  d.Free;
  mask.Free;
  end;

procedure TForm1.Button1Click(Sender: TObject);
  begin
  mask.Free;
  mask := GetRandomMask(n);
  Memo3.Clear;
  With Memo3.Lines do begin
    Add('n = ' + n.AsString);
    Add('n hat ' + IntToStr(n.DecimalCount) + ' Dezimalstellen.');
    Add('mask = ' + mask.AsString);
    Add('mask hat ' + IntToStr(mask.DecimalCount) + ' Dezimalstellen.');
    Add('maxL = ' + IntToStr(maxL));
    end;
  Memo2.Clear;  
  BtnDecode.Enabled := False;
  end;

procedure TForm1.BtnEncryptClick(Sender: TObject);
  var m, s : String;
      z : TVLInt;
  begin
  m := Memo1.Text;
  Memo2.Clear;
  Memo3.Clear;
  z := TVLInt.Create('0');
  While Length(m) > 0 do begin
    If Length(m) > maxL then begin
      s := Copy(m, 1, maxL);
      Delete(m, 1, maxL);
      end
    else begin
      s := m;
      m := '';
      end;
    GetVLIntFromNumString(s, z);
    z.X_OR(mask);
    Memo2.Lines.Add(z.AsString);
    end;
  z.Free;
  BtnDecode.Enabled := True;
  end;

procedure TForm1.BtnDecryptClick(Sender: TObject);
  var dest,
      s   : String;
      z   : TVLInt;
      i   : Integer;
  begin
  BtnDecode.Cursor := crHourGlass;
  Memo3.Clear;
  z  := TVLint.Create('0');
  dest := '';
  For i := 0 to Pred(Memo2.Lines.Count) do begin
    s  := Memo2.Lines[i];
    z.ResetTo(s);
//    Memo3.Lines.Add(z.AsString);
//    Memo3.Lines.Add(mask.AsString);
    z.X_OR(mask);
//    z.X_OR(mask);
//    Memo3.Lines.Add(z.AsString);
    GetNumStringFromVLInt(z, s);
//    Memo3.Lines.Add(s);
    dest := dest + s;
    end;
  Memo3.Text := dest;
  z.Free;
  BtnDecode.Cursor := crDefault;
  end;

end.
