UNIT mTVLInt;

interface

//--------------------  ggf Uses-Liste einfgen !  --------------------

uses classes, sysutils, dialogs;

type
   TVLInt = CLASS(TObject)
     protected
       FDigits : TList;
     public
       constructor Create(s: String);
       procedure Free;
       procedure SetDigit(nr, val: Integer);
       function GetDigit(nr: Integer) : Integer;
       function AsString : String;
     end;


implementation


const DigitBase : Integer = 10;

//+---------------------------------------------------------------------
//|         TVLInt: Methodendefinition
//+---------------------------------------------------------------------

//-------- Create (public) ---------------------------------------------
constructor TVLInt.Create(s: String);
  var i, k : Integer;
  begin
  Inherited Create;
  FDigits := TList.Create;
  For i := Length(s) downto 1 do
    If s[i] = ' ' then Delete(s, i, 1);
  i := Length(s);
  FDigits.Count := i;
  k := 0;
  While i > 0 do begin
    SetDigit(k, StrToInt(s[i]));
    k := k + 1;
    i := i - 1;
    end;
  end;

//-------- Free (public) -----------------------------------------------
procedure TVLInt.Free;
  begin
  If Assigned(Self) then begin
    FDigits.Free;
    Inherited Free;
    end;
  end;

//-------- SetDigit (public) ----------------------------------------
procedure TVLInt.SetDigit(nr, val: Integer);
  begin
  If nr < 0 then
    MessageDlg('Negative Stellennummer!', mtError, [mbOk], 0)
  else begin
    If nr >= FDigits.Count then
      FDigits.Count := nr + 1;
    FDigits.Items[nr] := Pointer(val);
    end;
  end;

//-------- GetDigit (public) ----------------------------------------
function TVLInt.GetDigit(nr: Integer) : Integer;
  begin
  If nr < 0 then begin
    MessageDlg('Negative Stellennummer!', mtError, [mbOk], 0);
    Result := 0;
    end
  else
    If nr >= FDigits.Count then
      Result := 0
    else
      Result := Integer(FDigits.Items[nr]);
  end;

//-------- AsString (public) -------------------------------------------
function TVLInt.AsString : String;
  var i : Integer;
  begin
  Result := '';
  For i := 0 to Pred(FDigits.Count) do
    Result := IntToStr(GetDigit(i)) + Result;
  end;

end.
