UNIT mTVLInt;

interface

//--------------------  ggf Uses-Liste einfgen !  --------------------

uses classes, sysutils, dialogs;

type
   TVLInt = CLASS(TObject)
     protected
        FDigits : TList;
        FIsNegativ : Boolean;
        function GetDigit(nr: Integer) : Integer;
        procedure SetDigit(nr, val: Integer);
     public
        constructor Create(s: String);
        constructor CreateCopyOf(Source: TVLInt);
        procedure Free;
        procedure Assign(Source: TVLint);
        function IsNegativ : Boolean;
        function AsString : String;
        function DigitCount : Integer;
        property digit[nr: Integer]: Integer read GetDigit write SetDigit;
     end;


implementation


const DigitBase : Integer = 10;

//+---------------------------------------------------------------------
//|         TVLInt: Methodendefinition
//+---------------------------------------------------------------------

//-------- Create (public) ---------------------------------------------
constructor TVLInt.Create(s: String);
  var i, k : Integer;
  begin
  Inherited Create;
  FDigits := TList.Create;
  For i := Length(s) downTo 1 do    // Alle unerwarteten Zeichen killen
    If Not (s[i] in ['+', '-', '0'..'9']) then
      System.Delete(s, i, 1);
  FIsNegativ := s[1] = '-';         // Vorzeichen erkennen und vermerken
  For i := Length(s) downTo 1 do    // Alle "+" und "-" killen
    If s[i] in ['+', '-'] then
      System.Delete(s, i, 1);
  While (Length(s) > 1) and (s[1] = '0') do
    System.Delete(s, 1, 1);         // Alle fhrenden Nullen killen
  i := Length(s);
  If (i > 0)  and (s <> '0') then begin
    FDigits.Count := i; // Gleich so gro wie ntig dimensionieren
    k := 0;
    While i > 0 do begin
      Digit[k] := StrToInt(s[i]);   // Stellen in Liste eintragen
      k := k + 1;
      i := i - 1;
      end;
    end
  else begin
    FIsNegativ := False;
    Digit[0]   := 0;    // Auch "" wird auch als "0" interpretiert !
    end;
  end;

//-------- CreateCopyOf (public) ---------------------------------------
constructor TVLInt.CreateCopyOf(Source: TVLInt);
  begin
  Inherited Create;
  FDigits := TList.Create;
  Assign(Source);           // Daten holen
  end;

//-------- Assign (public) ---------------------------------------------
procedure TVLInt.Assign(Source: TVLInt);
  var i : Integer;
  begin
  FDigits.Clear;                      // Aktuellen Inhalt lschen
  FDigits.Count := Source.DigitCount; // Gleich gengend Platz reservieren!
  For i := 0 to Pred(DigitCount) do
    Digit[i] := Source.Digit[i];      // Alle Ziffern bertragen
  FIsNegativ := Source.IsNegativ;     // Vorzeichen bertragen
  end;

//-------- Free (public) -----------------------------------------------
procedure TVLInt.Free;
  begin
  If Assigned(Self) then begin
    FDigits.Free;
    Inherited Free;
    end;
  end;

//-------- SetDigit (protected) ----------------------------------------
procedure TVLInt.SetDigit(nr, val: Integer);
  begin
  If nr < 0 then
    MessageDlg('Negative Stellennummer!', mtError, [mbOk], 0)
  else begin
    If nr >= FDigits.Count then
      FDigits.Count := nr + 1;
    FDigits.Items[nr] := Pointer(val);
    end;
  end;

//-------- GetDigit (protected) ----------------------------------------
function TVLInt.GetDigit(nr: Integer) : Integer;
  begin
  If nr < 0 then begin
    MessageDlg('Negative Stellennummer!', mtError, [mbOk], 0);
    Result := 0;
    end
  else
    If nr >= DigitCount then
      Result := 0
    else
      Result := Integer(FDigits.Items[nr]);
  end;

//-------- AsString (public) -------------------------------------------
function TVLInt.AsString : String;
  var i : Integer;
  begin
  Result := '';
  For i := 0 to Pred(DigitCount) do
    Result := IntToStr(digit[i]) + Result;
  If IsNegativ then
    Result := '-' + Result;
  end;

//-------- DigitCount (public) -----------------------------------------
function TVLInt.DigitCount : Integer;
  begin
  Result := FDigits.Count;
  end;

//-------- IsNegativ (public) ------------------------------------------
function TVLInt.IsNegativ : Boolean;
  begin
  Result := FIsNegativ;
  end;

end.
