UNIT mTVLInt;

interface

//--------------------  ggf Uses-Liste einfgen !  --------------------

uses classes, sysutils, dialogs;

type
   TVLInt = CLASS(TObject)
     protected
        FDigits : TList;
        FIsNegativ : Boolean;
        function AbsCompareWith(CVLI: TVLInt): Integer;
        function GetDigit(nr: Integer) : Integer;
        procedure SetDigit(nr, val: Integer);
        procedure KillLeadingZeros;
        procedure AddAbs(S2: TVLInt);
        procedure SubtrAbs(Sd: TVLInt);
     public
        constructor Create(s: String);
        constructor CreateCopyOf(Source: TVLInt);
        procedure Free;
        function AsString : String;
        function DigitCount : Integer;
        function IsNegativ : Boolean;
        function IsNull : Boolean;
        function IsEqual(CVLI: TVLInt) : Boolean;
        function IsGreaterThan(CVLI: TVLInt) : Boolean;
        function IsGreaterOrEqualThan(CVLI: TVLInt) : Boolean;
        procedure ChangeSign;
        procedure Assign(Source: TVLint);
        procedure Add(S2: TVLInt);
        procedure Subtr(Sd: TVLInt);
        procedure MultInt(F2: Integer);
        procedure ShiftLeft(d: Integer);
        property Digit[nr: Integer]: Integer read GetDigit write SetDigit;
     end;


implementation


const DigitBase : Integer = 10;

//+---------------------------------------------------------------------
//|         TVLInt: Methodendefinition
//+---------------------------------------------------------------------

//-------- Create (public) ---------------------------------------------
constructor TVLInt.Create(s: String);
  var i, k : Integer;
  begin
  Inherited Create;
  FDigits := TList.Create;
  For i := Length(s) downTo 1 do    // Alle unerwarteten Zeichen killen
    If Not (s[i] in ['+', '-', '0'..'9']) then
      System.Delete(s, i, 1);
  FIsNegativ := s[1] = '-';         // Vorzeichen erkennen und vermerken
  For i := Length(s) downTo 1 do    // Alle "+" und "-" killen
    If s[i] in ['+', '-'] then
      System.Delete(s, i, 1);
  While (Length(s) > 1) and (s[1] = '0') do
    System.Delete(s, 1, 1);         // Alle fhrenden Nullen killen
  i := Length(s);
  If (i > 0)  and (s <> '0') then begin
    FDigits.Count := i; // Gleich so gro wie ntig dimensionieren
    k := 0;
    While i > 0 do begin
      Digit[k] := StrToInt(s[i]);   // Stellen in Liste eintragen
      k := k + 1;
      i := i - 1;
      end;
    end
  else begin
    FIsNegativ := False;
    Digit[0]   := 0;    // Auch "" wird auch als "0" interpretiert !
    end;
  end;

//-------- CreateCopyOf (public) ---------------------------------------
constructor TVLInt.CreateCopyOf(Source: TVLInt);
  begin
  Inherited Create;
  FDigits := TList.Create;
  Assign(Source);           // Daten holen
  end;

//-------- Free (public) -----------------------------------------------
procedure TVLInt.Free;
  begin
  If Assigned(Self) then begin
    FDigits.Free;
    Inherited Free;
    end;
  end;

//-------- Assign (public) ---------------------------------------------
procedure TVLInt.Assign(Source: TVLInt);
  var i : Integer;
  begin
  FDigits.Clear;                      // Aktuellen Inhalt lschen
  FDigits.Count := Source.DigitCount; // Gleich gengend Platz reservieren!
  For i := 0 to Pred(DigitCount) do
    Digit[i] := Source.Digit[i];      // Alle Ziffern bertragen
  FIsNegativ := Source.IsNegativ;     // Vorzeichen bertragen
  end;

//-------- KillLeadingZeros (protected) --------------------------------
procedure TVLInt.KillLeadingZeros;
  // Eine "listen-nahe" Implementierung fr das Lschen
  // fhrender Nullen sorgt fr einen flotten Ablauf.
  begin
  With FDigits do
    While (Count > 1) and (Last = Nil) do
      Delete(Pred(Count));
  end;

//--------- AddAbs (protected) -----------------------------------------
procedure TVLInt.AddAbs(S2: TVLInt);
  var carry,        // bertrag
      ssum,         // Stellensumme
      gsz,          // grere (der beiden) Stellenzahl(en)
      i : Integer;  // Laufvariable
  begin
  carry := 0;
  If Self.DigitCount > S2.DigitCount then
    gsz := Self.DigitCount
  else
    gsz := S2.DigitCount;
  For i := 0 to gsz - 1 do begin
    ssum := Digit[i] + S2.Digit[i] + carry;
    Digit[i] := ssum Mod 10;
    carry    := ssum Div 10;
    end;
  If carry > 0 then
    Digit[gsz] := carry;
  end;

//--------- SubtrAbs (protected) ---------------------------------------
procedure TVLInt.SubtrAbs(Sd: TVLInt);
  var borrow,       // Geborgter Wert
      sdiff,        // Stellendifferenz
      i : Integer;  // Laufvariable
  begin
  borrow := 0;
  i := 0;
  While (i < Sd.DigitCount) or (borrow > 0) do begin
    sdiff := Digit[i] - (Sd.Digit[i] + borrow);
    If sdiff < 0 then begin
      Digit[i] := sdiff + 10;
      borrow   := 1;
      end
    else begin
      Digit[i] := sdiff;
      borrow   := 0;
      end;
    i := i + 1;
    // Die folgende Abfrage dient nur als Notbremse whrend der Entwicklung!
    // Sie kann spter entfernt werden, wenn SubtrAbs als "protected" versteckt
    // wird; bei allen internen Aufrufen muss dann sichergestellt werden, dass
    // der Fall "|Subtrahend| > |Minuend|", also "|Sd| > |Self|" nicht mehr
    // eintreten kann.
    If (i >= DigitCount) and (borrow > 0) then begin
      MessageDlg('Negative Differenz!', mtError, [mbOk], 0);
      Exit;
      end;
    end;
  KillLeadingZeros;
  end;

//-------- SetDigit (protected) ----------------------------------------
procedure TVLInt.SetDigit(nr, val: Integer);
  begin
  If nr < 0 then
    MessageDlg('Negative Stellennummer!', mtError, [mbOk], 0)
  else begin
    If nr >= DigitCount then
      FDigits.Count := nr + 1;
    FDigits.Items[nr] := Pointer(val);
    end;
  end;

//-------- GetDigit (protected) ----------------------------------------
function TVLInt.GetDigit(nr: Integer) : Integer;
  begin
  If nr < 0 then begin
    MessageDlg('Negative Stellennummer!', mtError, [mbOk], 0);
    Result := 0;
    end
  else
    If nr >= DigitCount then
      Result := 0
    else
      Result := Integer(FDigits.Items[nr]);
  end;

//--------- AbsCompareWith (protected) ---------------------------------
function TVLInt.AbsCompareWith(CVLI: TVLInt): Integer;
  var i : Integer;
  begin
  If DigitCount > CVLI.DigitCount then
    Result := 1
  else
  if DigitCount < CVLI.DigitCount then
    Result := -1
  else begin       // Im Fall "DigitCount = CVLI.DigitCount" machen wir die
    Result := 0;   // vorlufige Annahme, dass die beiden Betrge gleich sind;
    i := Pred(DigitCount);
                   // Dann wird der hchst-wertige Unterschied gesucht.
    While (i >= 0) and (digit[i] = CVLI.digit[i]) do
      i := i - 1;
    If i >= 0 then // Falls eine Stelle mit verschiedenen Ziffern gefunden
                   // wurde, zeigt i jetzt auf die hchstwertige Stelle, in
                   // der sich die beiden Betrge unterscheiden
      If digit[i] > CVLI.digit[i] then
        Result := 1
      else
        Result := -1;
    end;
  end;

//-------- AsString (public) -------------------------------------------
function TVLInt.AsString : String;
  var i : Integer;
  begin
  Result := '';
  For i := 0 to Pred(DigitCount) do
    Result := IntToStr(digit[i]) + Result;
  If IsNegativ then
    Result := '-' + Result;
  end;

//-------- DigitCount (public) -----------------------------------------
function TVLInt.DigitCount : Integer;
  begin
  Result := FDigits.Count;
  end;

//-------- IsNegativ (public) ------------------------------------------
function TVLInt.IsNegativ : Boolean;
  begin
  Result := FIsNegativ;
  end;

//-------- IsNull (public) ---------------------------------------------
function TVLInt.IsNull : Boolean;
  var i : Integer;
  begin
  Result := True;
  i := Pred(DigitCount);
  While Result and (i >= 0) do
    If digit[i] <> 0 then
      Result := False
    else
      i := i - 1;
  end;

//--------- IsEqual (public) -------------------------------------------
function TVLInt.IsEqual(CVLI: TVLInt): Boolean;
  var i : Integer;
  begin
  If (IsNegativ  = CVLI.IsNegativ) and
     (DigitCount = CVLI.DigitCount) then begin
    Result := True;
    i := Pred(DigitCount);
    While Result and (i >= 0) do
      If digit[i] = CVLI.digit[i] then
        i := i - 1
      else
        Result := False;
    end
  else
    Result := False;
  end;

//--------- IsGreaterThan (public) -------------------------------------
function TVLInt.IsGreaterThan(CVLI: TVLInt): Boolean;
  begin
  If IsNegativ <> CVLI.IsNegativ then  // verschiedene Vorzeichen
    Result := CVLI.IsNegativ
  else                                 // gleiche Vorzeichen
    If IsNegativ then
      Result := AbsCompareWith(CVLI) < 0
    else
      Result := AbsCompareWith(CVLI) > 0;
  end;

//--------- IsGreaterOrEqualThan (public) ------------------------------
function TVLInt.IsGreaterOrEqualThan(CVLI: TVLInt): Boolean;
  begin
  If IsNegativ <> CVLI.IsNegativ then  // verschiedene Vorzeichen
    Result := CVLI.IsNegativ
  else                                 // gleiche Vorzeichen
    If IsNegativ then
      Result := AbsCompareWith(CVLI) <= 0
    else
      Result := AbsCompareWith(CVLI) >= 0;
  end;

//--------- ChangeSign (public) ----------------------------------------
procedure TVLInt.ChangeSign;
  begin
  If Not IsNull then
    FIsNegativ := Not IsNegativ;
  end;

//--------- Add (public) -----------------------------------------------
procedure TVLInt.Add(S2: TVLInt);
  var Pu : TVLInt;
  begin
  If IsNegativ = S2.IsNegativ then  // Gleiche Vorzeichen
    AddAbs(S2)
  else                              // Verschiedene Vorzeichen
    Case Self.AbsCompareWith(S2) of
      1 : SubtrAbs(S2);
      0 : begin
          FDigits.Count := 1;
          FDigits.Items[0] := Nil;
          FIsNegativ := False;
          end;
     -1 : begin
          Pu := TVLInt.CreateCopyOf(S2);
          Pu.SubtrAbs(Self);
          Self.Assign(Pu);
          Pu.Free;
          end;
    end;
  end;

//--------- Subtr (public) ---------------------------------------------
procedure TVLInt.Subtr(Sd: TVLInt);
  begin
  If Not Sd.IsNull then begin
    Sd.ChangeSign;    // Gegenzahl basteln, ...
    Add(Sd);          // ... ersatzweise addieren ...
    Sd.ChangeSign;    // ... und Vorzeichen wieder zurcksetzen!
    end;
  end;

//--------- MultInt (public) ----------------------------------------
procedure TVLInt.MultInt(F2: Integer);
  var p, u, i, k : Integer;
  begin
  u := 0;
  i := 0;
  k := DigitCount - 1;  // Index der hchsten besetzten Stelle
  While i <= k do begin
    p := digit[i] * F2 + u;
    digit[i] := p MOD 10;
    u := p DIV 10;
    i := i + 1;
    end;
  If u > 0 then
    Digit[DigitCount] := u;
  end;

//--------- ShiftLeft (public) --------------------------------------
procedure TVLInt.ShiftLeft(d: Integer);
  var i : Integer;
  begin
  If d > 0 then begin
    For i := DigitCount - 1 DownTo 0 do
      Digit[i + d] := Digit[i];
    For i := d-1 DownTo 0 do
      Digit[i] := 0;
    end;
  end;

end.
