unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, ExtCtrls,
  mTVLInt, mRSATools, xxcode;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Memo1: TMemo;
    BtnEncode: TButton;
    Label2: TLabel;
    Memo2: TMemo;
    BtnDecode: TButton;
    Label3: TLabel;
    Memo3: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure BtnEncryptClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BtnDecryptClick(Sender: TObject);
  private
    { Private-Deklarationen }
    n, e, d : TVLInt;
    maxL    : Integer;   { Maximale Lnge eines zu kodierenden Strings }
    CTLL    : Integer;   { "C"rypted "T"ext "L"ine "L"ength            }
    b64Codec: TXXCoDec;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

const
  n_str = '811868017044547855930206335286847482071623415221390766576678253985172660938678171';
  e_str = '35';
  d_str = '139177374350493918159463943192030996926485879552494963476498518158805501987806939';


procedure TForm1.FormCreate(Sender: TObject);
  begin
  n := TVLInt.Create(n_str);
  e := TVLInt.Create(e_str);
  d := TVLInt.Create(d_str);
  maxL := GetMaxStrLength(n);
  CTLL := 60;
  b64CoDec := TXXCoDec.Create('');
  end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
  begin
  n.Free;
  e.Free;
  d.Free;
  b64CoDec.Free;
  end;

procedure TForm1.BtnEncryptClick(Sender: TObject);
  var m, s     : String;
      mask, z  : TVLInt;
      eb       : Byte;
      MS       : TMemoryStream;
      i, k     : Integer;
  begin
  Memo2.Clear;
  Memo3.Clear;

  MS := TMemoryStream.Create;
  MS.Position := 0;

  mask := GetRandomMask(maxL);   // XOR-Schlssel erzeugen,
  z := TVLInt.Create('0');
  ExpMod(mask, e, n, z);         //    RSA-verschlsseln und
  z.WriteToStream(MS);           //    Ergebnis abspeichern, dann
  GetNumStringFromVLInt(mask, s);//    Schlssel-Bytes auspacken
  z.Free;
  mask.Free;

  m := Memo1.Text;               // Botschaft in einen String zusammenpacken
  k := 1;
  For i := 1 to Length(m) do begin
    eb := Ord(m[i]) XOR Ord(s[k]);         // Zeichenweise verschlsseln und
    MS.WriteBuffer(eb, 1);                 //    in den Stream schreiben
    k := k + 1;
    If k > Length(s) then
      k := 1;
    end;

  b64CoDec.EncryptStream2XXString(MS, s);  // Base64-Kodierung
  MS.Free;

  While Length(s) > CTLL do begin          // Geheimtext auf mehrere Zeilen
    m := Copy(s, 1, CTLL);                 //   verteilen
    Delete(s, 1, CTLL);
    Memo2.Lines.Add(m);
    end;
  If Length(s) > 0 then
    Memo2.Lines.Add(s);

  BtnDecode.Enabled := True;
  end;

procedure TForm1.BtnDecryptClick(Sender: TObject);
  var dest, s : String;
      MS      : TMemoryStream;
      mask, z : TVLInt;
      eb      : Byte;
      i, k    : Integer;
  begin
  BtnDecode.Cursor := crHourGlass;
  Memo3.Clear;

  s := '';
  For i := 0 to Pred(Memo2.Lines.Count) do   // Zusammenfassen
    s := s + Memo2.Lines[i];                 // (entfernt Zeilenumbrche)

  MS := TMemoryStream.Create;
  b64CoDec.DecryptXXString2Stream(s, MS);    // Base64-Dekodierung
  MS.Position := 0;

  mask := TVLInt.Create('0');
  z := TVLInt.Create('0');
  z.ReadFromStream(MS);                      // XOR-Schlssel laden,
  ExpMod(z, d, n, mask);                     //   dekodieren und
  GetNumStringFromVLInt(mask, s);            //   Schlssel-Bytes auspacken
  z.Free;
  mask.Free;

  k    := 1;
  dest := '';
  While MS.Position < MS.Size do begin
    MS.ReadBuffer(eb, 1);
    dest := dest + Chr(eb XOR Ord(s[k]));    // Text zeichenweise dekodieren
    k := k + 1;
    If k > Length(s) then
      k := 1;
    end;

  MS.Free;
  Memo3.Text := dest;                        // Dekodierten Text ausgeben

  BtnDecode.Cursor := crDefault;
  end;

end.
