unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, ExtCtrls,
  xxcode;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Memo1: TMemo;
    BtnEncode: TButton;
    Label2: TLabel;
    Memo2: TMemo;
    BtnDecode: TButton;
    Label3: TLabel;
    Memo3: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure BtnEncryptClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BtnDecryptClick(Sender: TObject);
  private
    { Private-Deklarationen }
    maxL    : Integer;
    XXCodec : TXXCodec;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
  begin
  XXCodec := TXXCodec.Create('');
  maxL := 60;
  end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
  begin
  XXCodec.Free;
  end;

procedure TForm1.BtnEncryptClick(Sender: TObject);
  var m, s   : String;
      n, i   : Integer;
      Stream : TMemoryStream;
  begin
  Memo2.Clear;
  Memo3.Clear;

  Stream := TMemoryStream.Create;               // Alle Daten aus Memo1 in
  For i := 0 to Pred(Memo1.Lines.Count) do begin  //  den Stream schreiben
    m := Memo1.Lines[i];
    n := Length(m);
    Stream.Write(n, SizeOf(n));                 // Zeilenlnge abspeichern,
    Stream.Write(m[1], n);                      // dann Zeilen-Inhalt schreiben
    end;
  XXCodec.EncryptStream2XXString(Stream, m);    // Gemeinsam verschlsseln
  Stream.Free;

  While Length(m) > 0 do begin                  // Geheimtext zeilenweise
    If Length(m) > maxL then begin              //    in Memo2 ausgeben
      s := Copy(m, 1, maxL);
      Delete(m, 1, maxL);
      end
    else begin
      s := m;
      m := '';
      end;
    Memo2.Lines.Add(s);
    end;

  BtnDecode.Enabled := True;
  end;

procedure TForm1.BtnDecryptClick(Sender: TObject);
  var Stream : TMemoryStream;
      s      : String;
      n, i   : Integer;
  begin
  BtnDecode.Cursor := crHourGlass;
  Memo3.Clear;

  Stream := TMemoryStream.Create;            // Geheimtext in String s laden
  For i := 0 to Pred(Memo2.Lines.Count) do begin
    s := s + Memo2.Lines[i];                 // CR-LF-Umbrche unterdrcken !
    end;
  XXCodec.DecryptXXString2Stream(s, Stream); // In *einem* Rutsch dekodieren

  // Jetzt enthlt der Stream den Klartext, und zwar in demselben Format, in
  //   dem er beim Verschlsseln in den Verschlsselungs-Stream geschrieben
  //   wurde: jedem String ist seine (Integer-)Lnge vorangestellt !

  Stream.Position := 0;
  While Stream.Position < Stream.Size do begin // Solange noch Daten da sind...
    Stream.Read(n, SizeOf(n));               // Zeilenlnge auslesen
    SetLength(s, n);                         // Zielvariable dimensionieren
    Stream.Read(s[1], n);                    // Daten holen und
    Memo3.Lines.Add(s);                      // in Memo3 schreiben !
    end;
  Stream.Free;

  BtnDecode.Cursor := crDefault;
  end;

end.
