import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
  *
  * Beschreibung
  *
  * @version 1.0 vom 06.07.2012
  * @author
  */

public class recuGraph extends JFrame {
  // Anfang Attribute
  private JPanel jPanel1 = new JPanel(null, true);
  private JButton jButton1 = new JButton();
  private ButtonGroup jButtonGroup1 = new ButtonGroup();
  private JRadioButton jRadioButton1 = new JRadioButton();
  private JRadioButton jRadioButton2 = new JRadioButton();
  private JRadioButton jRadioButton3 = new JRadioButton();
  private Turtle t = new Turtle(100, 100);
  // Ende Attribute
  
  public recuGraph(String title) {
    // Frame-Initialisierung
    super(title);
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 485; 
    int frameHeight = 492;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setResizable(true);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    
    jPanel1.setBounds(0, 0, 473, 65);
    jPanel1.setOpaque(false);
    cp.add(jPanel1);
    jButton1.setBounds(288, 16, 89, 33);
    jButton1.setText("Zeichne");
    jButton1.setMargin(new Insets(2, 2, 2, 2));
    jButton1.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        jButton1_ActionPerformed(evt);
      }
    });
    jPanel1.add(jButton1);
    t.setBounds(8, 72, 465, 385);
    cp.add(t);
    addComponentListener(new ComponentAdapter() {
      public void componentResized(ComponentEvent evt) { 
        recuGraph_ComponentResized(evt);
      }
    });
    setTitle("Rekursive Graphik");
    jRadioButton1.setBounds(24, 8, 153, 17);
    jRadioButton1.setText("Farn");
    jRadioButton1.setOpaque(false);
    jButtonGroup1.add(jRadioButton1);

    jRadioButton1.setSelected(true);
    jPanel1.add(jRadioButton1);
    jRadioButton2.setBounds(24, 24, 161, 17);
    jRadioButton2.setText("Koch'sche Kurve");
    jRadioButton2.setOpaque(false);
    jButtonGroup1.add(jRadioButton2);

    jPanel1.add(jRadioButton2);
    jRadioButton3.setBounds(24, 40, 161, 17);
    jRadioButton3.setText("Pythagoras-Baum");
    jRadioButton3.setOpaque(false);
    jButtonGroup1.add(jRadioButton3);

    jPanel1.add(jRadioButton3);
    // Ende Komponenten
    
    setVisible(true);
  } // end of public recuGraph
  
  private void farn(double len) {
    if (len > 2) {
      t.draw(len);
      t.turn( 25); farn(len * 0.5);
      t.turn(-35); farn(len * 0.7);
      t.turn(-25); farn(len * 0.4);
      t.turn( 35);
      t.draw(-len);
    } else {
      t.draw( len);
      t.draw(-len);
    }
  }
  
  private void koch(double len) {
    if (len > 2) {
      koch(len / 3);
      t.turn(60);
      koch(len / 3);
      t.turn(-120);
      koch(len/3);
      t.turn(60);
      koch(len/3);
    } else {
      t.draw(len);
    }
  }
  
  private void pyth(double len) {
    if (len > 4) {
      // Hypothenuse zeichnen
      t.draw(len);
      t.turn(150);
      // Groes Katheten-Quadrat zeichnen
      double k1 = len * 0.5 * Math.sqrt(3);
      t.draw(k1);
      t.turn(-90);
      t.draw(k1);
      t.turn(-90);
      pyth(k1);
      t.turn(-90);
      t.draw(k1);
      t.turn(-90);
      t.draw(k1);
      t.turn(90);
      // Kleines Katheten-Quadrat zeichnen
      double k2 = len * 0.5;
      t.draw(k2);
      t.turn(-90);
      t.draw(k2);
      t.turn(-90);
      pyth(k2);
      t.turn(-90);
      t.draw(k2);
      t.turn(-90);
      t.draw(k2);
      // Nochmal(!) Hypothenuse zeichnen !!
      t.turn(120);
      t.draw(len);
    } else {
      t.draw(len);
    }
  }
  
  // Anfang Methoden
  public void jButton1_ActionPerformed(ActionEvent evt) {
    // TODO hier Quelltext einfgen
    t.clear();
    if (jRadioButton1.isSelected()) {
      t.turnto(90);
      t.moveto(0, -120);
      farn(80);
      t.move(120);
    } else {
      if (jRadioButton2.isSelected()) {
        t.turnto(0);
        t.moveto(-240, -80);
        koch(480);
        t.move(-120);
      } else {
        if (jRadioButton3.isSelected()) {
          t.turnto(0);
          t.moveto(-240, -80);
          pyth(150);
        }
      }    // end of if
    } // end of if-else
  } // end of jButton1_ActionPerformed
  
  public void recuGraph_ComponentResized(ComponentEvent evt) {
    jPanel1.setBounds(0, 0, getWidth(), 72);
    t.setBounds(0,73, getWidth(), getHeight()-72);
    t.setOrigin(t.getWidth() / 2, t.getHeight() / 2);
  } // end of recuGraph_ComponentResized
  
  public String getSelectedRadioButton(ButtonGroup bg) {
    for (java.util.Enumeration<AbstractButton> e = bg.getElements(); e.hasMoreElements();) {
      AbstractButton b = e.nextElement();
      if (b.isSelected()) return b.getText();
    }
    return null;
  }
  
  // Ende Methoden
  
  public static void main(String[] args) {
    new recuGraph("Rekursive Grafik");
  } // end of main
  
} // end of class recuGraph
