unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, MathEdit;

const maxAdrCnt = 1000;

type
  TDatum   = record
               tag      : Integer;
               monat    : Integer;
               jahr     : Integer;
             end;

  TAdresse = record
               Vorname  : String[60];
               Nachname : String[40];
               Strasse  : String[30];
               HausNr   : Integer;
               PLZ      : Integer;
               Ort      : String[30];
               Telefon  : String[20];
               GebDat   : TDatum;
             end;

  TForm1 = class(TForm)
    Ed_Vorname: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Ed_Nachname: TEdit;
    Label3: TLabel;
    Ed_Strasse: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    IEd_HNr: TIntEdit;
    IEd_PLZ: TIntEdit;
    Label6: TLabel;
    Ed_Ort: TEdit;
    Label7: TLabel;
    Ed_TelNr: TEdit;
    BtnSetData: TButton;
    Bevel1: TBevel;
    Label8: TLabel;
    IEd_GDTag: TIntEdit;
    Label9: TLabel;
    IEd_GDMon: TIntEdit;
    Label10: TLabel;
    IEd_GDJahr: TIntEdit;
    BtnBack: TButton;
    BtnForwd: TButton;
    Lbl_Index: TLabel;
    Bevel2: TBevel;
    RG_SuchFeld: TRadioGroup;
    Label11: TLabel;
    Ed_Such: TEdit;
    BtnStartSearch: TButton;
    BtnContSearch: TButton;
    BtnEnd: TButton;
    BtnBegin: TButton;
    BtnDelData: TButton;
    Bevel3: TBevel;
    procedure BtnSetDataClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure BtnBackClick(Sender: TObject);
    procedure BtnForwdClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BtnSearchClick(Sender: TObject);
    procedure BtnDelDataClick(Sender: TObject);
    procedure BtnBeginClick(Sender: TObject);
    procedure BtnEndClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Adressen    : Array [1..maxAdrCnt] of TAdresse;
    ActAdr,
    SearchPos   : Integer;
    DatFileName : String;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{=================== Initialisierung ======================}

procedure TForm1.FormCreate(Sender: TObject);
  { Unter Windows2000 und neueren Versionen ist der hier gewhlte
    Speicherort fr die Daten mglicherweise ungnstig:
    wenn Sie als "normaler Benutzer" mit eingeschrnkten Rechten angemeldet
    sind und das Programm in einem Unterverzeichnis des "Programme"-Ordners
    von Windows liegt, dann haben Sie dort keine Schreibrechte, knnen also
    auch keine Datei erzeugen.
    In diesem Fall muss ein anderer Pfad gewhlt werden. }
  var f : File of TAdresse;
  begin
  datfilename := ExtractFilePath(Application.ExeName) + 'adress.dat';
  If FileExists(DatFileName) then begin
    ActAdr := 1;
    AssignFile(f, DatFileName);
    Reset(f);
    While Not EOF(f) do begin
      Read(f, adressen[ActAdr]);
      ActAdr := ActAdr + 1;
      end;
    CloseFile(f);
    end;
  ActAdr := 1;
  end;

{=================== Anzeige ==============================}

procedure TForm1.FormPaint(Sender: TObject);
  begin
  If Adressen[ActAdr].Nachname = '' then begin
    Ed_Vorname.Text  := '';
    Ed_Nachname.Text := '';
    Ed_Strasse.Text  := '';
    IEd_HNr.Value    := 0;
    IEd_PLZ.Value    := 0;
    Ed_Ort.Text      := '';
    Ed_TelNr.Text    := '';
    IEd_GDTag.Value  := 0;
    IEd_GDMon.Value  := 0;
    IEd_GDJahr.Value := 0;
    end
  else begin
    Ed_Vorname.Text  := Adressen[ActAdr].Vorname;
    Ed_Nachname.Text := Adressen[ActAdr].Nachname;
    Ed_Strasse.Text  := Adressen[ActAdr].Strasse;
    IEd_HNr.Value    := Adressen[ActAdr].HausNr;
    IEd_PLZ.Value    := Adressen[ActAdr].PLZ;
    Ed_Ort.Text      := Adressen[ActAdr].Ort;
    Ed_TelNr.Text    := Adressen[ActAdr].Telefon;
    IEd_GDTag.Value  := Adressen[ActAdr].GebDat.tag;
    IEd_GDMon.Value  := Adressen[ActAdr].GebDat.monat;
    IEd_GDJahr.Value := Adressen[ActAdr].GebDat.jahr;
    end;
  Lbl_Index.Caption := 'Datensatz ' + IntToStr(ActAdr);
  end;

{======================= Navigation ==================}

procedure TForm1.BtnBeginClick(Sender: TObject);
  begin
  ActAdr := 1;
  Invalidate;
  end;

procedure TForm1.BtnBackClick(Sender: TObject);
  begin
  If ActAdr > 1 then begin
    ActAdr := ActAdr - 1;
    Invalidate;
    end;
  end;

procedure TForm1.BtnForwdClick(Sender: TObject);
  begin
  If Adressen[ActAdr].Nachname <> '' then begin
    ActAdr := ActAdr + 1;
    Invalidate;
    end;
  end;

procedure TForm1.BtnEndClick(Sender: TObject);
  begin
  While Adressen[ActAdr].Nachname <> '' do
    ActAdr := ActAdr + 1;
  Invalidate;
  end;

{================== Daten bearbeiten =================}

procedure TForm1.BtnSetDataClick(Sender: TObject);
  begin
  Adressen[ActAdr].Vorname  := Ed_Vorname.Text;
  Adressen[ActAdr].Nachname := Ed_Nachname.Text;
  Adressen[ActAdr].Strasse  := Ed_Strasse.Text;
  Adressen[ActAdr].HausNr   := IEd_HNr.Value;
  Adressen[ActAdr].PLZ      := IEd_PLZ.Value;
  Adressen[ActAdr].Ort      := Ed_Ort.Text;
  Adressen[ActAdr].Telefon  := Ed_TelNr.Text;
  Adressen[ActAdr].GebDat.tag   := IEd_GDTag.Value;
  Adressen[ActAdr].GebDat.monat := IEd_GDMon.Value;
  Adressen[ActAdr].GebDat.jahr  := IEd_GDJahr.Value;
  If ActAdr < maxAdrCnt then begin
    ActAdr := ActAdr + 1;
    Invalidate;
    end;
  end;

procedure TForm1.BtnDelDataClick(Sender: TObject);
  var i : Integer;
  begin
  If MessageDlg('Dieser Vorgang kann nicht rckgngig gemacht werden. '#13#10 +
                'Wollen Sie diesen Datensatz wirklich lschen?',
                mtWarning, [mbYes, mbNo], 0) = mrYes then begin
    i := ActAdr;
    Repeat
      Adressen[i] := Adressen[i + 1];   // kopiert den ganzen Record !
      i := i + 1;
    until Adressen[i].Nachname = '';
    Invalidate;
    end;
  end;

{================== Suchen ===========================}

procedure TForm1.BtnSearchClick(Sender: TObject);
  { Dies ist eine gemeinsame Klick-Prozedur fr die beiden Knpfe
    "Suche starten" und "Weitersuchen". Bei beiden Klick-Ereignissen
    muss fast dasselbe getan werden; lediglich die Variablen SearchPos
    darf nur bei einer *neu gestarteten* Suche auf Null zurckgesetzt
    werden. Von welchem Knopf die Prozedur tatschlich aufgerufen wird,
    wird mit Hilfe des Parameters "Sender" entschieden.                }
  var found : Boolean;
  begin
  found := False;
  If Sender = BtnStartSearch then    // SearchPos nur dann zurcksetzen,
    SearchPos := 0;                  // wenn die Suche neu gestartet wird !
  Repeat
    SearchPos := SearchPos + 1;
    Case RG_SuchFeld.ItemIndex of
      0 : found := UpperCase(Adressen[SearchPos].Nachname) = UpperCase(Ed_Such.Text);
      1 : found := UpperCase(Adressen[SearchPos].Vorname) = UpperCase(Ed_Such.Text);
      2 : found := UpperCase(Adressen[SearchPos].Ort) = UpperCase(Ed_Such.Text);
    end
  until found or (SearchPos = MaxAdrCnt) or (Adressen[SearchPos].Nachname = '');
  If found then begin
    ActAdr := SearchPos;
    Invalidate;           // fhrt zur Anzeige des gefundenen Datensatzes
    end
  else begin
    ShowMessage('"' + Ed_Such.Text + '" konnte nicht gefunden werden!');
    SearchPos := 0;       // Zurcksetzen fr neue Suche
    end;
  end;

{============== Programm-Ende ==========================}

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
  var f : File of TAdresse;
  begin
  AssignFile(f, DatFileName);
  Rewrite(f);
  ActAdr := 1;
  While (ActAdr <= maxAdrCnt) and
        (Adressen[ActAdr].Nachname > '') do begin
    Write(f, Adressen[ActAdr]);
    ActAdr := ActAdr + 1;
    end;
  CloseFile(f);
  end;

end.
