unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, mTurtle2, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    ButtonBaum: TButton;
    ButtonKoch: TButton;
    ButtonFarn: TButton;
    ButtonPeano: TButton;
    ButtonPythagoras: TButton;
    CheckBoxFarbig: TCheckBox;
    PaintBox1: TPaintBox;
    CB_Wait: TCheckBox;
    CB_Toggle: TCheckBox;
    procedure CB_ToggleClick(Sender: TObject);
    procedure CB_WaitClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonBaumClick(Sender: TObject);
    procedure ButtonKochClick(Sender: TObject);
    procedure ButtonFarnClick(Sender: TObject);
    procedure ButtonPeanoClick(Sender: TObject);
    procedure ButtonPythagorasClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Turtle1: TTurtle;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.ButtonBaumClick(Sender: TObject);

  procedure baum(len: Double);
    { Den rekursiven BAUM-Aufrufen im THEN-Zweig entsprechen die
      FD+BK-Aufrufe im ELSE-Teil, die die Grundfigur zeichnen und die
      Turtle wieder in *den* Zustand *vor* dem Zeichnen zurckfahren.
      Beachten Sie, dass die Prozedur BAUM dies ebenfalls macht!  }
    begin
    with Turtle1 do begin
      FD(len);
      If len > 2 then begin
        LT(45);
        baum(len*0.7);
        RT(90);
        baum(len*0.7);
        LT(45);
        end
      else begin
        LT(45);
        FD(len*0.7);
        BK(len*0.7);
        RT(90);
        FD(len*0.7);
        BK(len*0.7);
        LT(45);
        end;
      BK(len);
      end;
    end;

  begin
  With Turtle1 do begin
    CS;
    PU;
    BK(100);
    PD;
    end;
  baum(70);
  end;


procedure TForm1.ButtonKochClick(Sender: TObject);

  procedure koch(len: Double);
  { Hier ist ein schulmeisterliches Parade-Beispiel zur Rekursion:
    Im ELSE-Zweig der Entscheidung stehen die Befehle, die die Koch'sche
    Grundfigur zeichnen; im THEN-Zweig steht fast derselbe Code, nur sind
    alle FD-Aufrufe durch rekursive KOCH-Aufrufe ersetzt. Klarer kann man
    die Struktur kaum mehr herausarbeiten! }
    begin
    with Turtle1 do begin
      If len > 3 then begin
        koch(len/3);
        LT(60);
        koch(len/3);
        RT(120);
        koch(len/3);
        LT(60);
        koch(len/3);
        end
      else begin
        FD(len/3);
        LT(60);
        FD(len/3);
        RT(120);
        FD(len/3);
        LT(60);
        FD(len/3);
        end;
      end;
    end;

  begin
  with turtle1 do begin
    CS;
    PU;
    BK(30);
    RT(90);
    BK(125);
    PD;
    end;
  koch(250);
  end;


procedure TForm1.ButtonFarnClick(Sender: TObject);

  procedure farn(len: Double);
    { Dieser Algorithmus ist von anderer Art als der bei der Koch-Kurve:
      hier wird die Grundfigur garnicht mehr in der FD-Variante gezeichnet,
      sondern nur der "Stamm"-Strich, der die rekursiven Aufrufe einrahmt!
      Machen Sie sich klar, dass das trotzdem zu denselben Zeichnungen
      fhrt, wenn man nur *eine* Rekursions-Ebene weiter hinabsteigt!
      Knnen Sie den Algorithmus so ergnzen, dass er wie bei der
      Koch-Kurve funktioniert?                                         }
    begin
    with Turtle1 do begin
      FD(len);
      If len > 2 then begin
        LT(25);
        farn(len*0.5);
        RT(35);
        farn(len*0.7);
        RT(25);
        farn(len*0.4);
        LT(35);
        end;
      BK(len);
      end;
    end;

  begin
  With Turtle1 do begin
    CS;
    PU;
    BK(120);
    PD;
    end;
  farn(80);
  end;


procedure TForm1.ButtonPeanoClick(Sender: TObject);

  procedure peano(len: Double);
    { Hier nochmals ein Algorithmus im Stile des obigen Koch-Kurven-Zeichners:
      If ELSE-Zweig das explizite Zeichnen der Grundfigur, im THEN-Zweig
      dieselbe Struktur, aber statt den FD-Befehlen nun die Peano-Aufrufe! }
    begin
    with turtle1 do begin
      If len > 15 then begin
        peano(len/3);
        LT(90);
        peano(len/3);
        RT(90);
        peano(len/3);
        RT(90);
        peano(len/3);
        RT(90);
        peano(len/3);
        LT(90);
        peano(len/3);
        LT(90);
        peano(len/3);
        LT(90);
        peano(len/3);
        RT(90);
        peano(len/3);
        end
      else begin
        fd(len/3);
        LT(90);
        fd(len/3);
        RT(90);
        fd(len/3);
        RT(90);
        fd(len/3);
        RT(90);
        fd(len/3);
        LT(90);
        fd(len/3);
        LT(90);
        fd(len/3);
        LT(90);
        fd(len/3);
        RT(90);
        fd(len/3);
        end;
      end;
    end;

  begin
  With turtle1 do begin
    CS;
    PU;
    BK(125);
    PD;
    end;
  peano(250);
  end;


procedure TForm1.ButtonPythagorasClick(Sender: TObject);
  var w : Double;
      isColoured : Boolean;

  procedure pythbaum(len: Double);
    { Hier ist der Algorithmus relativ aufwendig, weil die Grundfigur schon
      erheblich komplizierter ist. Die Mglichkeit der Fllungen blht den
      Code weiter auf. Der Kern ist trotzdem recht bersichtlich:
      Die rekursiven Aufrufe geschehen nur, wenn die bergebene aktuelle Lnge
      mindestens 10 (Pixel) ist; andernfalls wird nur die Aussenkante des
      Kathetenquadrats gezeichnet (FD statt PythBaum!).  }
    var k1, k2 : Double;
    begin
    with Turtle1 do begin
      k1 := len * cos(pi * w / 180);
      k2 := len * sin(pi * w / 180);
      Color := clBlack;
      FD(len);
      LT(90 + w);
      FD(k2);  { 2. Kathete }
      LT(90);
      FD(k1);  { 1. Kathete }

      RT(90);
      FD(k1);
      RT(90);
      If len > 10 then
        pythbaum(k1)
      else
        FD(k1);
      RT(90);
      FD(k1);
      If isColoured then begin
        LT(45);
        PU;
        BK(k1/2);
        Fill(clGreen);
        FD(k1/2);
        LT(90);
        BK(k1/2);
        Fill(clRed);
        FD(k1/2);
        RT(45);
        PD;
        end
      else
        LT(90);

      FD(k2);
      RT(90);
      If len > 10 then
        pythbaum(k2)
      else
        FD(k2);
      RT(90);
      FD(k2);

      If IsColoured then begin
        LT(45);
        PU;
        BK(k1/2);
        Fill(clYellow);
        FD(k1/2);
        PD;
        LT(135-w);
        end
      else
        LT(180-w);
      end;
    end;

  begin
  With turtle1 do begin
    CS;
    PU;
    BK(100);
    RT(90);
    BK(100);
    PD;
    w := 60;
    isColoured := CheckBoxFarbig.Checked;
    end;
  pythbaum(75);
  end;

procedure TForm1.CB_WaitClick(Sender: TObject);
  begin
  if CB_Wait.State = cbChecked then
    Turtle1.WaitTime := 0
  else
    Turtle1.WaitTime := 10;
  end;

procedure TForm1.CB_ToggleClick(Sender: TObject);
  begin
  if CB_Toggle.State = cbChecked then
    Turtle1.ST
  else
    Turtle1.HT;
  end;

procedure TForm1.FormCreate(Sender: TObject);
  begin
  Turtle1 := TTurtle.Create(PaintBox1);
  Turtle1.WaitTime := 100;
  end;

procedure TForm1.FormResize(Sender: TObject);
  begin
  Turtle1.Resize;
  end;

end.
