unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MathEdit, Unit2, ExtCtrls, Buttons;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Label2: TLabel;
    Label3: TLabel;
    Memo2: TMemo;
    Panel1: TPanel;
    Label1: TLabel;
    IntEdit1: TIntEdit;
    BtnCreateCycls: TButton;
    BtnClose: TBitBtn;
    BtnHelp: TBitBtn;
    procedure BtnCreateCyclsClick(Sender: TObject);
    procedure BtnHelpClick(Sender: TObject);
    procedure BtnCloseClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Modul : Integer;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.BtnCreateCyclsClick(Sender: TObject);
  var n,    { aktuelles Element aus M }
      p,    { aktuelle Potenz von n }
      azl,  { aktuelle Zykluslnge }
      i : Integer;
      s  : String;                 { Ausgabe-Puffer }
      ready : Boolean;             { Kontrollvariable fr Repeat-Schleife }
      ms : Set of Byte;            { M als Menge }
      zl : Array [0..255] of Byte; { Liste der Zykluslngen }
  begin
  Modul := IntEdit1.Value;    { Modul holen und auf Gltigkeit berprfen }
  If Modul < 1 then begin
    ShowMessage('Der Modul muss positiv sein!');
    Exit;
    end;
  If Modul > 255 then begin
    ShowMessage('Dieses Programm kann nur Module < 256 untersuchen!');
    Exit;
    end;

  Memo1.Clear;                         { Initialisierungen }
  Memo2.Clear;
  Application.ProcessMessages;
  For i := 0 to 255 do zl[i] := 0;     { Zykluslngen-Liste zurcksetzen }

  For n := 1 to Pred(Modul) do begin   { Alle positiven Elemente von M durchlaufen }
    ms  := [0..255] - [n];
    ready := False;
    azl := 1;
    p := n;                       { Potenz mit aktueller Basis initialisieren }
    s := '(' + IntToStr(p);
    Repeat                        { Schleife fr den Potenzen-Zyklus }
      p := (p * n) mod Modul;     { Zur nchsten Potenz gehen }
      If p in ms then begin       { Falls diese Zahl noch nicht im aktuellen }
        ms := ms - [p];           {   Zyklus vorkam: Zyklus fortsetzen !  }
        s := s + ', ' + IntToStr(p);
        azl := azl + 1;
        end
      else begin                  { Andernfalls : Zyklus beenden, und zwar: }
        ready := True;
        If p = n  then            {   als echten, gltigen Zyklus abschlieen }
          s := s + ')'
        else begin                {   als unechten "Un-Zyklus" abbrechen }
          Delete(s, 1, 1);
          s := '  --- Kein Zyklus: [' + s + ', ' + IntToStr(p) + '....] ---';
          azl := 0;
          end;
        end;
    until ready;
    Memo1.Lines.Add(s);
    zl[azl] := zl[azl] + 1;
    end;

  For i := 255 DownTo 0 do        { Statistik der Zykluslngen ausgeben }
    If zl[i] > 0 then begin
      s := IntToStr(i);
      While Length(s) < 4 do s := ' ' + s;
      s := s + ' (' + IntToStr(zl[i]) + ')';
      Memo2.Lines.Add(s);
      end;
  If zl[0] > 0 then begin
    s := IntToStr(zl[0]);
    While Length(s) < 4 do s := ' ' + s;
    s := s + ' Schleifen';
    Memo2.Lines.Add(s)
    end;

  With IntEdit1 do begin
    SelStart  := 0;
    SelLength := Length(Text);
    SetFocus;
    end;
  end;

procedure TForm1.BtnHelpClick(Sender: TObject);
  begin
  Form2.ShowModal;
  end;

procedure TForm1.BtnCloseClick(Sender: TObject);
  begin
  Close;
  end;

end.
